/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.api.nbt;

import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.api.nbt.MergeContext;
import de.siphalor.nbtcrafting3.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting3.dollar.DollarExtractor;
import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.exception.UnresolvedDollarReferenceException;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import net.minecraft.nbt.NbtElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MergeBehavior {
    public static final MergeBehavior OVERWRITE = (base, addition, mergeContext, path) -> addition.copy();
    public static final MergeBehavior KEEP = (base, addition, mergeContext, path) -> base == null ? addition.copy() : base;
    public static final MergeBehavior UPDATE = (base, addition, mergeContext, path) -> base == null ? null : addition.copy();
    public static final MergeBehavior MERGE = (base, addition, mergeContext, path) -> {
        if (base == null) {
            return addition.copy();
        }
        if (NbtUtil.isCompound(base) && NbtUtil.isCompound(addition)) {
            NbtUtil.mergeInto(NbtUtil.asNbtCompound(base), NbtUtil.asNbtCompound(addition), mergeContext, path);
            return base;
        }
        if (NbtUtil.isList(base) && NbtUtil.isList(addition)) {
            NbtUtil.mergeInto(NbtUtil.asListTag(base), NbtUtil.asListTag(addition), mergeContext, path);
            return base;
        }
        return base;
    };
    public static final MergeBehavior PREPEND = (base, addition, mergeContext, path) -> {
        if (base == null) {
            return addition.copy();
        }
        if (NbtUtil.isList(base) && NbtUtil.isList(addition)) {
            NbtUtil.asListTag(base).addAll(0, NbtUtil.asListTag(addition));
            return base;
        }
        return base;
    };
    public static final MergeBehavior APPEND = (base, addition, mergeContext, path) -> {
        if (base == null) {
            return addition.copy();
        }
        if (NbtUtil.isList(base) && NbtUtil.isList(addition)) {
            NbtUtil.asListTag(base).addAll(NbtUtil.asListTag(addition));
            return base;
        }
        return base;
    };

    public NbtElement merge(@Nullable NbtElement var1, @NotNull NbtElement var2, @NotNull MergeContext var3, @NotNull String var4);

    public static MergeBehavior valueOf(String input) {
        switch (input) {
            case "overwrite": {
                return OVERWRITE;
            }
            case "keep": {
                return KEEP;
            }
            case "update": {
                return UPDATE;
            }
            case "merge": {
                return MERGE;
            }
            case "prepend": {
                return PREPEND;
            }
            case "append": {
                return APPEND;
            }
        }
        if (input.length() > 1 && input.charAt(0) == '$') {
            DollarPart expression = DollarExtractor.parse(input.substring(1));
            return (base, addition, mergeContext, path) -> {
                try {
                    return NbtUtil.asTag(expression.evaluate(ref -> {
                        if ("base".equals(ref)) {
                            return base;
                        }
                        if ("addition".equals(ref)) {
                            return addition;
                        }
                        throw new UnresolvedDollarReferenceException(ref);
                    }));
                }
                catch (DollarEvaluationException e) {
                    NbtCrafting.logError("Error evaluating merge behavior expression (" + input + ") for path " + path + ": " + e.getMessage());
                    return base;
                }
            };
        }
        throw new IllegalArgumentException("Unknown merge mode: " + input);
    }
}

