/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.api.nbt;

import de.siphalor.nbtcrafting3.api.nbt.MergeBehavior;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtElement;

public class MergeContext {
    public static final MergeContext EMPTY = new MergeContext(Collections.emptyList());
    private final Collection<Entry> entries;

    public MergeContext(Collection<Entry> entries) {
        this.entries = entries;
    }

    public static MergeContext parse(String basePath, NbtCompound compound) {
        if (compound.contains("paths", 10)) {
            if (!((String)basePath).isEmpty()) {
                basePath = (String)basePath + ".";
            }
            NbtCompound paths = compound.getCompound("paths");
            ArrayList<Entry> entries = new ArrayList<Entry>(paths.getSize());
            for (String key : paths.getKeys()) {
                MergeBehavior mergeBehavior = MergeBehavior.valueOf(paths.getString(key));
                if (key.startsWith("/") && key.endsWith("/")) {
                    entries.add(new PatternEntry(mergeBehavior, Pattern.compile(Pattern.quote((String)basePath) + key.substring(1, key.length() - 1))));
                    continue;
                }
                entries.add(new SimpleEntry(mergeBehavior, (String)basePath + key));
            }
            return new MergeContext(entries);
        }
        return EMPTY;
    }

    public MergeBehavior getMergeMode(NbtElement tag, String path) {
        for (Entry entry : this.entries) {
            if (!entry.test(tag, path)) continue;
            return entry.mergeBehavior;
        }
        return MergeBehavior.MERGE;
    }

    public static class PatternEntry
    extends Entry {
        private final Pattern pattern;

        public PatternEntry(MergeBehavior mergeBehavior, Pattern pattern) {
            super(mergeBehavior);
            this.pattern = pattern;
        }

        @Override
        public boolean test(NbtElement tag, String path) {
            return this.pattern.matcher(path).matches();
        }
    }

    public static class SimpleEntry
    extends Entry {
        private final String path;

        public SimpleEntry(MergeBehavior mergeBehavior, String path) {
            super(mergeBehavior);
            this.path = path;
        }

        @Override
        public boolean test(NbtElement tag, String path) {
            return this.path.equals(path);
        }
    }

    public static abstract class Entry {
        private final MergeBehavior mergeBehavior;

        public Entry(MergeBehavior mergeBehavior) {
            this.mergeBehavior = mergeBehavior;
        }

        public abstract boolean test(NbtElement var1, String var2);
    }
}

