/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.api.nbt;

import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.nbt.AbstractNbtList;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtElement;

@FunctionalInterface
public interface NbtIterator {
    public Action process(String var1, String var2, NbtElement var3);

    public static void iterateTags(NbtElement tag, NbtIterator nbtIterator) {
        NbtIterator.iterateTags(tag, nbtIterator, "");
    }

    public static void iterateTags(NbtElement tag, NbtIterator nbtIterator, String path) {
        block14: {
            block13: {
                if (tag == null) {
                    return;
                }
                if (!(tag instanceof NbtCompound)) break block13;
                NbtCompound compoundTag = (NbtCompound)tag;
                if (!((String)path).equals("")) {
                    path = (String)path + ".";
                }
                HashSet<String> remove = new HashSet<String>();
                for (String key : compoundTag.getKeys()) {
                    NbtElement currentTag = compoundTag.get(key);
                    switch (nbtIterator.process((String)path, key, currentTag)) {
                        case REMOVE: {
                            remove.add(key);
                            break;
                        }
                        case RECURSE: {
                            NbtIterator.iterateTags(currentTag, nbtIterator, (String)path + key);
                            break;
                        }
                    }
                }
                for (String key : remove) {
                    compoundTag.remove(key);
                }
                break block14;
            }
            if (!(tag instanceof AbstractNbtList)) break block14;
            AbstractNbtList listTag = (AbstractNbtList)tag;
            int i = 0;
            Iterator iterator = listTag.iterator();
            while (iterator.hasNext()) {
                NbtElement currentTag = (NbtElement)iterator.next();
                switch (nbtIterator.process((String)path, "[" + i + "]", currentTag)) {
                    case REMOVE: {
                        iterator.remove();
                        break;
                    }
                    case RECURSE: {
                        NbtIterator.iterateTags(currentTag, nbtIterator, (String)path + "[" + i + "]");
                        break;
                    }
                }
            }
        }
    }

    public static enum Action {
        RECURSE,
        SKIP,
        REMOVE;

    }
}

