/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.api.nbt;

import com.google.gson.JsonElement;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.api.nbt.MergeBehavior;
import de.siphalor.nbtcrafting3.api.nbt.MergeContext;
import de.siphalor.nbtcrafting3.api.nbt.NbtException;
import de.siphalor.nbtcrafting3.api.nbt.NbtNumberRange;
import de.siphalor.nbtcrafting3.dollar.DollarUtil;
import de.siphalor.nbtcrafting3.util.BetterJsonOps;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.AbstractNbtList;
import net.minecraft.nbt.AbstractNbtNumber;
import net.minecraft.nbt.NbtByte;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtDouble;
import net.minecraft.nbt.NbtElement;
import net.minecraft.nbt.NbtFloat;
import net.minecraft.nbt.NbtInt;
import net.minecraft.nbt.NbtList;
import net.minecraft.nbt.NbtLong;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtShort;
import net.minecraft.nbt.NbtString;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Contract;

public class NbtUtil {
    public static final NbtCompound EMPTY_COMPOUND = new NbtCompound();

    public static NbtCompound getTagOrEmpty(ItemStack itemStack) {
        if (itemStack.hasTag()) {
            return itemStack.getTag();
        }
        return EMPTY_COMPOUND;
    }

    public static NbtCompound copyOrEmpty(NbtCompound compoundTag) {
        if (compoundTag == null) {
            return new NbtCompound();
        }
        return compoundTag.copy();
    }

    public static boolean tagsMatch(NbtElement main, NbtElement reference) {
        if (NbtUtil.isString(reference) && reference.asString().equals("")) {
            return true;
        }
        if (NbtUtil.isString(main) && NbtUtil.isString(reference)) {
            return main.asString().equals(reference.asString());
        }
        if (NbtUtil.isNumeric(main)) {
            if (NbtUtil.isNumeric(reference)) {
                return NbtUtil.asNumberTag(main).doubleValue() == NbtUtil.asNumberTag(reference).doubleValue();
            }
            if (NbtUtil.isString(reference) && reference.asString().startsWith("$")) {
                return NbtNumberRange.ofString(reference.asString().substring(1)).matches(NbtUtil.asNumberTag(main).doubleValue());
            }
            return false;
        }
        return false;
    }

    public static boolean compoundsOverlap(NbtCompound main, NbtCompound reference) {
        for (String key : main.getKeys()) {
            if (!reference.contains(key)) continue;
            NbtElement mainTag = main.get(key);
            NbtElement refTag = reference.get(key);
            if (!(NbtUtil.isCompound(mainTag) && NbtUtil.isCompound(refTag) ? NbtUtil.compoundsOverlap(main.getCompound(key), reference.getCompound(key)) : (NbtUtil.isList(mainTag) && NbtUtil.isList(refTag) ? NbtUtil.listsOverlap(NbtUtil.asListTag(main.get(key)), NbtUtil.asListTag(reference.get(key))) : NbtUtil.tagsMatch(main.get(key), reference.get(key))))) continue;
            return true;
        }
        return false;
    }

    public static boolean listsOverlap(AbstractNbtList<NbtElement> main, AbstractNbtList<NbtElement> reference) {
        for (NbtElement mainTag : main) {
            for (NbtElement referenceTag : main) {
                if (!(NbtUtil.isCompound(mainTag) && NbtUtil.isCompound(referenceTag) ? NbtUtil.compoundsOverlap(NbtUtil.asNbtCompound(mainTag), NbtUtil.asNbtCompound(referenceTag)) : (NbtUtil.isList(mainTag) && NbtUtil.isList(referenceTag) ? NbtUtil.listsOverlap(NbtUtil.asListTag(mainTag), NbtUtil.asListTag(referenceTag)) : NbtUtil.tagsMatch(mainTag, referenceTag)))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCompoundContained(NbtCompound inner, NbtCompound outer) {
        for (String key : inner.getKeys()) {
            NbtElement innerTag = inner.get(key);
            if (!outer.contains(key)) {
                return false;
            }
            NbtElement outerTag = outer.get(key);
            if (NbtUtil.isCompound(innerTag) && NbtUtil.isCompound(outerTag)) {
                if (NbtUtil.isCompoundContained(NbtUtil.asNbtCompound(innerTag), NbtUtil.asNbtCompound(outerTag))) continue;
                return false;
            }
            if (NbtUtil.isList(innerTag) && NbtUtil.isList(outerTag)) {
                if (NbtUtil.isListContained(NbtUtil.asListTag(innerTag), NbtUtil.asListTag(outerTag))) continue;
                return false;
            }
            if (NbtUtil.tagsMatch(outerTag, innerTag)) continue;
            return false;
        }
        return true;
    }

    public static boolean isListContained(AbstractNbtList<NbtElement> inner, AbstractNbtList<NbtElement> outer) {
        for (NbtElement innerTag : inner) {
            boolean success = false;
            for (NbtElement outerTag : outer) {
                if (NbtUtil.isCompound(innerTag) && NbtUtil.isCompound(outerTag) && NbtUtil.isCompoundContained(NbtUtil.asNbtCompound(innerTag), NbtUtil.asNbtCompound(outerTag))) {
                    success = true;
                    break;
                }
                if (NbtUtil.isList(innerTag) && NbtUtil.isList(outerTag) && NbtUtil.isListContained(NbtUtil.asListTag(innerTag), NbtUtil.asListTag(outerTag))) {
                    success = true;
                    break;
                }
                if (!NbtUtil.tagsMatch(innerTag, outerTag)) continue;
                success = true;
                break;
            }
            if (success) continue;
            return false;
        }
        return true;
    }

    public static boolean sameType(NbtElement tag1, NbtElement tag2) {
        return tag1.getType() == tag2.getType();
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isString(NbtElement tag) {
        return tag instanceof NbtString;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isCompound(NbtElement tag) {
        return tag instanceof NbtCompound;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isList(NbtElement tag) {
        return tag instanceof AbstractNbtList;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNumeric(NbtElement tag) {
        return tag instanceof AbstractNbtNumber;
    }

    public static String asString(NbtElement tag) {
        if (tag instanceof AbstractNbtNumber) {
            return ((AbstractNbtNumber)tag).numberValue().toString();
        }
        if (tag instanceof NbtString) {
            return tag.asString();
        }
        if (tag instanceof NbtList) {
            StringJoiner joiner = new StringJoiner(", ");
            for (NbtElement entry : (NbtList)tag) {
                String s = NbtUtil.asString(entry);
                joiner.add(s);
            }
            return joiner.toString();
        }
        return tag.toString();
    }

    public static NbtString asStringTag(NbtElement tag) {
        return (NbtString)tag;
    }

    public static NbtCompound asNbtCompound(NbtElement tag) {
        return (NbtCompound)tag;
    }

    public static AbstractNbtList<NbtElement> asListTag(NbtElement tag) {
        return (AbstractNbtList)tag;
    }

    public static AbstractNbtNumber asNumberTag(NbtElement tag) {
        return (AbstractNbtNumber)tag;
    }

    public static NbtElement getTag(NbtElement main, String path) {
        return NbtUtil.getTag(main, NbtUtil.splitPath(path));
    }

    public static NbtElement getTag(NbtElement main, String[] pathKeys) {
        NbtElement currentTag = main;
        for (String pathKey : pathKeys) {
            if ("".equals(pathKey)) continue;
            if (currentTag == null) {
                return null;
            }
            if (pathKey.charAt(0) == '[') {
                int index = Integer.parseUnsignedInt(pathKey.substring(1, pathKey.length() - 2), 10);
                if (NbtUtil.isList(currentTag)) {
                    AbstractNbtList<NbtElement> list = NbtUtil.asListTag(currentTag);
                    if (index >= list.size()) {
                        return null;
                    }
                    currentTag = (NbtElement)list.get(index);
                    continue;
                }
                return null;
            }
            if (NbtUtil.isCompound(currentTag)) {
                NbtCompound compound = NbtUtil.asNbtCompound(currentTag);
                if (compound.contains(pathKey)) {
                    currentTag = compound.get(pathKey);
                    continue;
                }
                return null;
            }
            return null;
        }
        return currentTag;
    }

    public static NbtElement getTagOrCreate(NbtElement main, String path) throws NbtException {
        return NbtUtil.getTagOrCreate(main, NbtUtil.splitPath(path));
    }

    public static NbtElement getTagOrCreate(NbtElement main, String[] pathParts) throws NbtException {
        NbtElement currentTag = main;
        for (String pathPart : pathParts) {
            if ("".equals(pathPart)) continue;
            if (pathPart.charAt(0) == '[') {
                if (!NbtUtil.isList(currentTag)) {
                    throw new NbtException(String.join((CharSequence)".", pathParts) + " doesn't match on " + main.asString());
                }
                AbstractNbtList<NbtElement> currentList = NbtUtil.asListTag(currentTag);
                int index = Integer.parseUnsignedInt(pathPart.substring(1, pathPart.length() - 1));
                if (currentList.size() <= index) {
                    throw new NbtException(String.join((CharSequence)".", pathParts) + " contains invalid list in " + main.asString());
                }
                if (NbtUtil.isCompound((NbtElement)currentList.get(index)) || NbtUtil.isList((NbtElement)currentList.get(index))) {
                    currentTag = (NbtElement)currentList.get(index);
                    continue;
                }
                throw new NbtException(String.join((CharSequence)".", pathParts) + " doesn't match on " + main.asString());
            }
            if (!NbtUtil.isCompound(currentTag)) {
                throw new NbtException(String.join((CharSequence)".", pathParts) + " doesn't match on " + main.asString());
            }
            NbtCompound currentCompound = NbtUtil.asNbtCompound(currentTag);
            if (!currentCompound.contains(pathPart)) {
                NbtCompound newCompound = new NbtCompound();
                currentCompound.put(pathPart, (NbtElement)newCompound);
                currentTag = newCompound;
                continue;
            }
            if (NbtUtil.isCompound(currentCompound.get(pathPart)) || NbtUtil.isList(currentCompound.get(pathPart))) {
                currentTag = currentCompound.get(pathPart);
                continue;
            }
            throw new NbtException(String.join((CharSequence)".", pathParts) + " doesn't match on " + main.asString());
        }
        return currentTag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void put(NbtElement main, String[] pathParts, NbtElement tag) throws NbtException {
        NbtElement parent = NbtUtil.getTagOrCreate(main, (String[])ArrayUtils.subarray((Object[])pathParts, (int)0, (int)(pathParts.length - 1)));
        String key = pathParts[pathParts.length - 1];
        if (key.charAt(0) == '[') {
            int i = Integer.parseUnsignedInt(key.substring(1, key.length() - 1));
            if (!NbtUtil.isList(parent)) throw new NbtException(String.join((CharSequence)".", pathParts) + " doesn't match on " + main.asString());
            if (tag == null) {
                NbtUtil.asListTag(parent).remove(i);
                return;
            } else {
                try {
                    NbtUtil.asListTag(parent).add(i, tag);
                    return;
                }
                catch (Exception e) {
                    throw new NbtException("Can't add tag " + tag.asString() + " to list: " + parent.asString());
                }
            }
        } else {
            if (!NbtUtil.isCompound(parent)) throw new NbtException(String.join((CharSequence)".", pathParts) + " doesn't match on " + main.asString());
            if (tag == null) {
                NbtUtil.asNbtCompound(parent).remove(key);
                return;
            } else {
                NbtUtil.asNbtCompound(parent).put(key, tag);
            }
        }
    }

    public static String[] splitPath(String path) {
        return path.split("\\.|(?=\\[)");
    }

    public static String getLastKey(String path) {
        return path.substring(path.lastIndexOf(46) + 1);
    }

    public static void mergeInto(NbtCompound target, NbtCompound additions, boolean replace) {
        if (additions == null) {
            return;
        }
        for (String key : additions.getKeys()) {
            if (!target.contains(key)) {
                target.put(key, additions.get(key).copy());
                continue;
            }
            NbtElement targetTag = target.get(key);
            NbtElement additionsTag = additions.get(key);
            if (NbtUtil.isCompound(targetTag) && NbtUtil.isCompound(additionsTag)) {
                NbtUtil.mergeInto(NbtUtil.asNbtCompound(targetTag), NbtUtil.asNbtCompound(additionsTag), replace);
                continue;
            }
            if (NbtUtil.isList(targetTag) && NbtUtil.isList(additionsTag)) {
                int targetSize = NbtUtil.asListTag(targetTag).size();
                AbstractNbtList<NbtElement> listTag = NbtUtil.asListTag(targetTag);
                for (NbtElement tag : NbtUtil.asListTag(additionsTag)) {
                    NbtElement copy = tag.copy();
                    listTag.add((Object)tag);
                }
                continue;
            }
            if (!replace) continue;
            target.put(key, additionsTag.copy());
        }
    }

    public static void mergeInto(NbtCompound target, NbtCompound additions, MergeContext context, String basePath) {
        if (additions == null) {
            return;
        }
        if (!((String)basePath).isEmpty()) {
            basePath = (String)basePath + ".";
        }
        for (String key : additions.getKeys()) {
            String path = (String)basePath + key;
            NbtElement targetTag = target.get(key);
            MergeBehavior mergeBehavior = context.getMergeMode(targetTag, path);
            NbtElement additionTag = additions.get(key);
            assert (additionTag != null);
            NbtElement merged = mergeBehavior.merge(targetTag, additionTag, context, path);
            if (merged == targetTag) continue;
            target.put(key, merged);
        }
    }

    public static void mergeInto(AbstractNbtList<NbtElement> target, AbstractNbtList<NbtElement> additions, MergeContext context, String basePath) {
        String path;
        int i;
        if (additions == null) {
            return;
        }
        int targetSize = target.size();
        int additionsSize = additions.size();
        for (i = 0; i < additions.size() && i < targetSize; ++i) {
            path = basePath + "[" + i + "]";
            NbtElement targetTag = (NbtElement)target.get(i);
            MergeBehavior mergeBehavior = context.getMergeMode(targetTag, path);
            if (mergeBehavior == MergeBehavior.APPEND) {
                try {
                    target.add((Object)((NbtElement)additions.get(i)).copy());
                }
                catch (Exception e) {
                    NbtCrafting.logError("Can't append tag " + ((NbtElement)additions.get(i)).asString() + " to list: " + target.asString());
                }
                continue;
            }
            NbtElement additionTag = (NbtElement)additions.get(i);
            assert (additionTag != null);
            NbtElement merged = mergeBehavior.merge(targetTag, additionTag, context, path);
            if (merged == targetTag) continue;
            target.set(i, merged);
        }
        for (i = targetSize; i < additionsSize; ++i) {
            path = basePath + "[" + i + "]";
            MergeBehavior mergeBehavior = context.getMergeMode(null, path);
            NbtElement tag = mergeBehavior.merge(null, (NbtElement)additions.get(i), context, path);
            if (tag == null) continue;
            target.add((Object)tag);
        }
    }

    public static NbtElement asTag(Object value) {
        if (value instanceof NbtElement) {
            return (NbtElement)value;
        }
        if (value instanceof String) {
            return NbtString.of((String)((String)value));
        }
        if (value instanceof Float) {
            return NbtFloat.of((float)((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return NbtDouble.of((double)((Double)value));
        }
        if (value instanceof Byte) {
            return NbtByte.of((byte)((Byte)value));
        }
        if (value instanceof Character) {
            return NbtString.of((String)String.valueOf(value));
        }
        if (value instanceof Short) {
            return NbtShort.of((short)((Short)value));
        }
        if (value instanceof Integer) {
            return NbtInt.of((int)((Integer)value));
        }
        if (value instanceof Long) {
            return NbtLong.of((long)((Long)value));
        }
        if (value instanceof Boolean) {
            return NbtByte.of((byte)((byte)((Boolean)value != false ? 1 : 0)));
        }
        if (value instanceof List) {
            NbtList listTag = new NbtList();
            for (Object element : (List)value) {
                listTag.add((Object)NbtUtil.asTag(element));
            }
            return listTag;
        }
        if (value instanceof Map) {
            NbtCompound compoundTag = new NbtCompound();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                compoundTag.put(DollarUtil.asString(entry.getKey()), NbtUtil.asTag(entry.getValue()));
            }
            return compoundTag;
        }
        if (value instanceof ItemStack) {
            return NbtUtil.getTagOrEmpty((ItemStack)value);
        }
        return null;
    }

    public static Object toDollarValue(NbtElement value) {
        if (value instanceof NbtString) {
            return value.asString();
        }
        if (value instanceof NbtFloat) {
            return Float.valueOf(((NbtFloat)value).floatValue());
        }
        if (value instanceof NbtDouble) {
            return ((NbtDouble)value).doubleValue();
        }
        if (value instanceof NbtByte) {
            return ((NbtByte)value).byteValue();
        }
        if (value instanceof NbtShort) {
            return ((NbtShort)value).shortValue();
        }
        if (value instanceof NbtInt) {
            return ((NbtInt)value).intValue();
        }
        if (value instanceof NbtLong) {
            return ((NbtLong)value).longValue();
        }
        if (value instanceof NbtElement) {
            return value;
        }
        return null;
    }

    public static NbtElement asTag(JsonElement jsonElement) {
        return (NbtElement)Dynamic.convert((DynamicOps)BetterJsonOps.INSTANCE, (DynamicOps)NbtOps.INSTANCE, (Object)jsonElement);
    }

    public static JsonElement toJson(NbtElement tag) {
        return (JsonElement)Dynamic.convert((DynamicOps)NbtOps.INSTANCE, (DynamicOps)BetterJsonOps.INSTANCE, (Object)tag);
    }
}

