/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.client;

import com.google.common.collect.ImmutableMap;
import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.mixin.RecipeManagerAccessor;
import de.siphalor.nbtcrafting3.mixin.client.AnvilScreenAccessor;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gui.screen.ingame.AnvilScreen;
import net.minecraft.client.network.ClientPlayNetworkHandler;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.recipe.Recipe;
import net.minecraft.recipe.RecipeManager;
import net.minecraft.recipe.RecipeSerializer;
import net.minecraft.recipe.RecipeType;
import net.minecraft.util.Identifier;
import net.minecraft.util.registry.Registry;

public class NbtCraftingClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ClientLoginNetworking.registerGlobalReceiver((Identifier)NbtCrafting.PRESENCE_CHANNEL, (client, handler, buf, listenerAdder) -> CompletableFuture.completedFuture(new PacketByteBuf(Unpooled.buffer())));
        ClientPlayNetworking.registerGlobalReceiver((Identifier)NbtCrafting.UPDATE_ANVIL_TEXT_S2C_PACKET_ID, (client, handler, buf, responseSender) -> {
            if (MinecraftClient.getInstance().currentScreen instanceof AnvilScreen) {
                ((AnvilScreenAccessor)MinecraftClient.getInstance().currentScreen).getNameField().setText(buf.readString());
            } else {
                buf.readString();
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((Identifier)NbtCrafting.UPDATE_ADVANCED_RECIPES_PACKET_ID, NbtCraftingClient::receiveAdvancedRecipePacket);
    }

    private static synchronized void receiveAdvancedRecipePacket(MinecraftClient client, ClientPlayNetworkHandler handler, PacketByteBuf buf, PacketSender responseSender) {
        RecipeManager recipeManager = handler.getRecipeManager();
        Map<RecipeType<?>, Map<Identifier, Recipe<?>>> recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        recipeMap = new HashMap(recipeMap);
        NbtCrafting.advancedIngredientSerializationEnabled.set(true);
        int recipeCount = buf.readVarInt();
        if (recipeCount == 0) {
            while (buf.isReadable()) {
                NbtCraftingClient.readRecipe(buf, recipeMap);
            }
        } else {
            for (int i = 0; i < recipeCount; ++i) {
                NbtCraftingClient.readRecipe(buf, recipeMap);
            }
        }
        NbtCrafting.advancedIngredientSerializationEnabled.set(false);
        ((RecipeManagerAccessor)recipeManager).setRecipes((Map<RecipeType<?>, Map<Identifier, Recipe<?>>>)ImmutableMap.copyOf(recipeMap));
    }

    private static void readRecipe(PacketByteBuf buf, Map<RecipeType<?>, Map<Identifier, Recipe<?>>> recipes) {
        RecipeSerializer serializer = (RecipeSerializer)Registry.RECIPE_SERIALIZER.get(buf.readIdentifier());
        if (serializer == null) {
            throw new IllegalStateException("Unknown recipe serializer on advanced recipe sync: " + buf.readIdentifier());
        }
        Identifier id = buf.readIdentifier();
        Recipe recipe = serializer.read(id, buf);
        Map recipeType = recipes.computeIfAbsent(recipe.getType(), rt -> new HashMap());
        recipeType.put(id, recipe);
    }

    public static RecipeManager getClientRecipeManager() {
        return MinecraftClient.getInstance().getNetworkHandler().getRecipeManager();
    }
}

