/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar;

import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.api.nbt.MergeContext;
import de.siphalor.nbtcrafting3.api.nbt.NbtIterator;
import de.siphalor.nbtcrafting3.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting3.dollar.Dollar;
import de.siphalor.nbtcrafting3.dollar.DollarScriptParserErrorListener;
import de.siphalor.nbtcrafting3.dollar.DollarScriptVisitor;
import de.siphalor.nbtcrafting3.dollar.antlr.DollarScriptLexer;
import de.siphalor.nbtcrafting3.dollar.antlr.DollarScriptParser;
import de.siphalor.nbtcrafting3.dollar.exception.UnresolvedDollarReferenceException;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.type.CountDollar;
import de.siphalor.nbtcrafting3.dollar.type.MergeDollar;
import de.siphalor.nbtcrafting3.dollar.type.SimpleDollar;
import de.siphalor.nbtcrafting3.shadow.antlr.runtime.CharStreams;
import de.siphalor.nbtcrafting3.shadow.antlr.runtime.CommonTokenStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.AbstractNbtList;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtElement;

public final class DollarExtractor {
    private DollarExtractor() {
    }

    public static Dollar[] extractDollars(NbtCompound compoundTag, boolean remove) {
        LinkedList dollars = new LinkedList();
        NbtIterator.iterateTags((NbtElement)compoundTag, (path, key, tag) -> {
            if (key.equals("$")) {
                if (NbtUtil.isList(tag)) {
                    AbstractNbtList<NbtElement> list = NbtUtil.asListTag(tag);
                    for (NbtElement t : list) {
                        DollarExtractor.parseMerge(t, path).ifPresent(dollars::addLast);
                    }
                } else {
                    DollarExtractor.parseMerge(tag, path).ifPresent(dollars::addLast);
                }
                return remove ? NbtIterator.Action.REMOVE : NbtIterator.Action.SKIP;
            }
            if (NbtUtil.isString(tag) && !tag.asString().isEmpty() && tag.asString().charAt(0) == '$') {
                DollarPart expression = DollarExtractor.parse(tag.asString().substring(1));
                if (expression != null) {
                    if (key.equals("nbtcrafting3:count")) {
                        dollars.addFirst(new CountDollar(expression));
                    } else {
                        dollars.addFirst(new SimpleDollar(expression, path + key));
                    }
                }
                return remove ? NbtIterator.Action.REMOVE : NbtIterator.Action.SKIP;
            }
            return NbtIterator.Action.RECURSE;
        });
        return dollars.toArray(new Dollar[0]);
    }

    private static Optional<MergeDollar> parseMerge(NbtElement tag, String path) {
        if (NbtUtil.isString(tag)) {
            DollarPart expression;
            String val = tag.asString();
            if (val.charAt(0) == '$') {
                val = val.substring(1);
            }
            if ((expression = DollarExtractor.parse(val)) == null) {
                return Optional.empty();
            }
            return Optional.of(new MergeDollar(expression, path, MergeContext.EMPTY));
        }
        if (NbtUtil.isCompound(tag)) {
            NbtCompound compound = NbtUtil.asNbtCompound(tag);
            if (compound.contains("value", 8)) {
                MergeContext mergeContext = MergeContext.parse(path, compound);
                DollarPart expression = DollarExtractor.parse(compound.getString("value"));
                if (expression == null) {
                    return Optional.empty();
                }
                return Optional.of(new MergeDollar(expression, path, mergeContext));
            }
            NbtCrafting.logError("The value field is required on dollar merge objects. Errored on " + tag.asString());
        } else {
            NbtCrafting.logError("Found invalid dollar merge tag: " + tag.asString());
        }
        return Optional.empty();
    }

    public static DollarPart parse(String string) {
        return DollarExtractor.parse(string, true);
    }

    public static DollarPart parse(String string, boolean reportErrors) {
        try {
            DollarScriptLexer lexer = new DollarScriptLexer(CharStreams.fromString(string));
            DollarScriptParser parser = new DollarScriptParser(new CommonTokenStream(lexer));
            lexer.removeErrorListeners();
            parser.removeErrorListeners();
            DollarScriptParserErrorListener errorListener = new DollarScriptParserErrorListener(Collections.singletonList(string));
            lexer.addErrorListener(errorListener);
            parser.addErrorListener(errorListener);
            DollarScriptParser.ScriptContext parseTree = parser.script();
            DollarPart expression = parseTree.accept(new DollarScriptVisitor());
            List<String> errors = errorListener.getErrors();
            if (!errors.isEmpty()) {
                if (reportErrors) {
                    NbtCrafting.logError("Errors while parsing dollar expression: " + string);
                    for (String error : errors) {
                        NbtCrafting.logError(error);
                    }
                }
                return null;
            }
            return expression;
        }
        catch (Exception e) {
            if (reportErrors) {
                NbtCrafting.logError("Unable to parse dollar expression: " + string + ": " + e.getMessage());
                e.printStackTrace();
            }
            return null;
        }
    }

    public static void main(String[] args) {
        DollarPart dollarPart = DollarExtractor.parse("map([{a:1,b:2},{a:3,b:4}],v->{v.c=v.a*v.b; v})");
        try {
            System.out.println(dollarPart.evaluate(ref -> {
                switch (ref) {
                    case "a": {
                        return 2;
                    }
                    case "b": {
                        return "b";
                    }
                }
                throw new UnresolvedDollarReferenceException(ref);
            }));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

