/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar;

import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.exception.IllegalDollarFunctionParameterException;
import de.siphalor.nbtcrafting3.dollar.function.DollarFunction;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;
import org.apache.commons.lang3.ArrayUtils;

public class DollarLambda
extends DollarFunction {
    private final String[] parameterNames;
    private final DollarPart body;

    public DollarLambda(String[] parameterNames, DollarPart body) {
        super("<lambda>");
        this.parameterNames = parameterNames;
        this.body = body;
    }

    @Override
    public boolean isParameterCountCorrect(int parameterCount) {
        return parameterCount == this.parameterNames.length;
    }

    @Override
    public void checkParameter(int index, Object parameter) {
    }

    @Override
    public Object callDirect(ReferenceResolver referenceResolver, Object ... parameters) throws DollarEvaluationException {
        if (parameters.length != this.parameterNames.length) {
            throw new DollarEvaluationException("Invalid number of arguments for lambda");
        }
        return this.body.evaluate(ref -> {
            int index = ArrayUtils.indexOf((Object[])this.parameterNames, (Object)ref);
            if (index >= 0) {
                return parameters[index];
            }
            return referenceResolver.resolve(ref);
        });
    }

    @Override
    public Object call(ReferenceResolver referenceResolver, DollarPart ... parameters) throws DollarEvaluationException, IllegalDollarFunctionParameterException {
        Object[] parameterValues = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterValues[i] = parameters[i].evaluate(referenceResolver);
        }
        return this.callDirect(referenceResolver, parameterValues);
    }
}

