/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar;

import de.siphalor.nbtcrafting3.shadow.antlr.runtime.ANTLRErrorListener;
import de.siphalor.nbtcrafting3.shadow.antlr.runtime.Parser;
import de.siphalor.nbtcrafting3.shadow.antlr.runtime.RecognitionException;
import de.siphalor.nbtcrafting3.shadow.antlr.runtime.Recognizer;
import de.siphalor.nbtcrafting3.shadow.antlr.runtime.atn.ATNConfigSet;
import de.siphalor.nbtcrafting3.shadow.antlr.runtime.dfa.DFA;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class DollarScriptParserErrorListener
implements ANTLRErrorListener {
    private final List<String> inputLines;
    private final List<String> errors = new ArrayList<String>();

    public DollarScriptParserErrorListener(List<String> inputLines) {
        this.inputLines = inputLines;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        StringBuilder errorBuilder = new StringBuilder();
        errorBuilder.append("Syntax error at ").append(line).append(":").append(charPositionInLine).append(": ").append(msg).append("\n");
        this.printErrorInputPointer(errorBuilder, line, charPositionInLine);
        this.errors.add(errorBuilder.toString());
    }

    @Override
    public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
    }

    @Override
    public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
    }

    @Override
    public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
    }

    private void printErrorInputPointer(StringBuilder output, int line, int start) {
        output.append(this.inputLines.get(line - 1));
        output.append("\n");
        for (int i = 0; i < start; ++i) {
            output.append(" ");
        }
        output.append("^\n");
    }
}

