/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar;

import de.siphalor.nbtcrafting3.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting3.dollar.exception.DollarException;
import de.siphalor.nbtcrafting3.util.NumberUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtElement;

public class DollarUtil {
    public static boolean asBoolean(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() != 0;
        }
        if (o instanceof String) {
            return !o.equals("");
        }
        return !DollarUtil.isEmpty(o);
    }

    public static String asString(Object o) {
        if (o == null) {
            return "<null>";
        }
        return o.toString();
    }

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof List) {
            return ((List)o).isEmpty();
        }
        if (o instanceof NbtCompound) {
            return ((NbtCompound)o).isEmpty();
        }
        return false;
    }

    public static Number expectNumber(Object o) throws DollarException {
        if (o == null) {
            return (byte)0;
        }
        if (o instanceof Number) {
            return (Number)o;
        }
        throw new DollarException("Cannot implicitly cast " + DollarUtil.asString(o) + " to a number");
    }

    public static Object toDollarValue(Object o) {
        if (o instanceof NbtElement) {
            return NbtUtil.toDollarValue((NbtElement)o);
        }
        return o;
    }

    public static boolean equals(Object a, Object b) {
        if (Objects.equals(a, b)) {
            return true;
        }
        if (a instanceof List && b instanceof List) {
            if (((List)a).size() != ((List)b).size()) {
                return false;
            }
            for (int i = 0; i < ((List)a).size(); ++i) {
                if (DollarUtil.equals(((List)a).get(i), ((List)b).get(i))) continue;
                return false;
            }
            return true;
        }
        if (a instanceof Number && b instanceof Number) {
            int type = NumberUtil.findSmallestType((Number)a, (Number)b);
            return Objects.equals(NumberUtil.cast((Number)a, type), NumberUtil.cast((Number)b, type));
        }
        return false;
    }
}

