/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar.function;

import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.exception.IllegalDollarFunctionParameterException;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ValueDollarPart;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;
import org.jetbrains.annotations.Contract;

public abstract class DollarFunction {
    protected final String name;

    public DollarFunction(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean isParameterCountCorrect(int var1);

    public abstract void checkParameter(int var1, Object var2) throws IllegalDollarFunctionParameterException;

    public Object callDirect(ReferenceResolver referenceResolver, Object ... parameters) throws DollarEvaluationException, IllegalDollarFunctionParameterException {
        DollarPart[] dollarParts = new DollarPart[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            dollarParts[i] = ValueDollarPart.of(parameters[i]);
        }
        return this.call(referenceResolver, dollarParts);
    }

    public abstract Object call(ReferenceResolver var1, DollarPart ... var2) throws DollarEvaluationException, IllegalDollarFunctionParameterException;

    @Contract(value="_, _, _ -> fail")
    protected void exceptParameterType(Object parameter, Object parameterIdentifier, Class<?> ... parameterClasses) throws IllegalDollarFunctionParameterException {
        if (parameter == null) {
            throw new IllegalDollarFunctionParameterException("Parameter " + parameterIdentifier + " to function " + this.name + " is null, but must not be null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Parameter ").append(parameterIdentifier.toString()).append(" to function ").append(this.getName()).append(" is of type ").append(parameter.getClass().getSimpleName());
        sb.append(", but expected to be one of ");
        for (int i = 0; i < parameterClasses.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (parameterClasses[i] == null) {
                sb.append("null");
                continue;
            }
            sb.append(parameterClasses[i].getSimpleName());
        }
        throw new IllegalDollarFunctionParameterException(sb.toString());
    }
}

