/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar.function;

import de.siphalor.nbtcrafting3.dollar.DollarUtil;
import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.exception.IllegalDollarFunctionParameterException;
import de.siphalor.nbtcrafting3.dollar.function.DollarFunction;
import de.siphalor.nbtcrafting3.dollar.function.StaticDollarFunction;
import de.siphalor.nbtcrafting3.dollar.function.VariadicNumericDollarFunction;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ValueDollarPart;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;
import de.siphalor.nbtcrafting3.util.NumberUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.util.registry.Registry;

public class DollarFunctions {
    private static final Map<String, DollarFunction> functions = new HashMap<String, DollarFunction>();

    public static void register(DollarFunction function) {
        functions.put(function.getName(), function);
    }

    public static DollarFunction get(String name) {
        return functions.get(name);
    }

    static {
        DollarFunctions.register(new DollarFunction("ifNull"){

            @Override
            public boolean isParameterCountCorrect(int parameterCount) {
                return parameterCount == 2;
            }

            @Override
            public void checkParameter(int index, Object parameter) {
            }

            @Override
            public Object call(ReferenceResolver referenceResolver, DollarPart ... parameters) throws DollarEvaluationException, IllegalDollarFunctionParameterException {
                Object value = parameters[0].evaluate(referenceResolver);
                if (value == null) {
                    return parameters[1].evaluate(referenceResolver);
                }
                return value;
            }
        });
        DollarFunctions.register(new DollarFunction("ifEmpty"){

            @Override
            public boolean isParameterCountCorrect(int parameterCount) {
                return parameterCount == 2;
            }

            @Override
            public void checkParameter(int index, Object parameter) {
            }

            @Override
            public Object call(ReferenceResolver referenceResolver, DollarPart ... parameters) throws DollarEvaluationException {
                Object value = parameters[0].evaluate(referenceResolver);
                if (DollarUtil.isEmpty(value)) {
                    return parameters[1].evaluate(referenceResolver);
                }
                return value;
            }
        });
        DollarFunctions.register(new StaticDollarFunction("count", (Class[][])new Class[][]{{ItemStack.class}}){

            @Override
            protected Object apply(Object[] parameters, ReferenceResolver referenceResolver) {
                return ((ItemStack)parameters[0]).getCount();
            }
        });
        DollarFunctions.register(new StaticDollarFunction("id", (Class[][])new Class[][]{{ItemStack.class}}){

            @Override
            protected Object apply(Object[] parameters, ReferenceResolver referenceResolver) {
                return Registry.ITEM.getId((Object)((ItemStack)parameters[0]).getItem()).toString();
            }
        });
        DollarFunctions.register(new StaticDollarFunction("maxCount", (Class[][])new Class[][]{{ItemStack.class}}){

            @Override
            protected Object apply(Object[] parameters, ReferenceResolver referenceResolver) {
                return ((ItemStack)parameters[0]).getMaxCount();
            }
        });
        DollarFunctions.register(new StaticDollarFunction("maxDamage", (Class[][])new Class[][]{{ItemStack.class}}){

            @Override
            protected Object apply(Object[] parameters, ReferenceResolver referenceResolver) {
                return ((ItemStack)parameters[0]).getMaxDamage();
            }
        });
        DollarFunctions.register(new StaticDollarFunction("size", (Class[][])new Class[][]{{List.class, NbtCompound.class, String.class}}){

            @Override
            protected Object apply(Object[] parameters, ReferenceResolver referenceResolver) {
                Class<?> clazz = parameters[0].getClass();
                if (parameters[0] instanceof List) {
                    return ((List)parameters[0]).size();
                }
                if (clazz == NbtCompound.class) {
                    return ((NbtCompound)parameters[0]).getSize();
                }
                if (clazz == String.class) {
                    return ((String)parameters[0]).length();
                }
                throw new AssertionError();
            }
        });
        DollarFunctions.register(new StaticDollarFunction("map", (Class[][])new Class[][]{{List.class}, {DollarFunction.class}}){

            @Override
            protected Object apply(Object[] parameters, ReferenceResolver referenceResolver) throws DollarEvaluationException {
                List list = (List)parameters[0];
                ArrayList<Object> mappedList = new ArrayList<Object>(list.size());
                DollarFunction mapper = (DollarFunction)parameters[1];
                for (Object value : list) {
                    try {
                        mappedList.add(mapper.callDirect(referenceResolver, value));
                    }
                    catch (IllegalDollarFunctionParameterException e) {
                        throw new DollarEvaluationException(e);
                    }
                }
                return mappedList;
            }
        });
        DollarFunctions.register(new StaticDollarFunction("distinct", 2, (Class[][])new Class[][]{{List.class}, {DollarFunction.class}, {Boolean.class}}){

            @Override
            protected Object apply(Object[] parameters, ReferenceResolver referenceResolver) throws DollarEvaluationException {
                List list = (List)parameters[0];
                DollarFunction unique = (DollarFunction)parameters[1];
                boolean keepFirst = parameters.length == 2 || (Boolean)parameters[2] != false;
                HashMap map = new HashMap();
                for (Object value : list) {
                    Object key;
                    try {
                        key = unique.call(referenceResolver, ValueDollarPart.of(value));
                    }
                    catch (DollarEvaluationException | IllegalDollarFunctionParameterException e) {
                        throw new DollarEvaluationException("Encountered error during evaluation of distinct function", e);
                    }
                    if (map.containsKey(key) && keepFirst) continue;
                    map.put(key, value);
                }
                return new ArrayList(map.values());
            }
        });
        DollarFunctions.register(new StaticDollarFunction("filter", (Class[][])new Class[][]{{List.class}, {DollarFunction.class}}){

            @Override
            protected Object apply(Object[] parameters, ReferenceResolver referenceResolver) throws DollarEvaluationException, IllegalDollarFunctionParameterException {
                List list = (List)parameters[0];
                DollarFunction filter = (DollarFunction)parameters[1];
                ArrayList filteredList = new ArrayList(list.size());
                for (Object value : list) {
                    if (!DollarUtil.asBoolean(filter.callDirect(referenceResolver, value))) continue;
                    filteredList.add(value);
                }
                return filteredList;
            }
        });
        DollarFunctions.register(new DollarFunction("combine"){

            @Override
            public boolean isParameterCountCorrect(int parameterCount) {
                return parameterCount > 1;
            }

            @Override
            public void checkParameter(int index, Object parameter) throws IllegalDollarFunctionParameterException {
                if (!(parameter instanceof List) && !(parameter instanceof NbtCompound)) {
                    this.exceptParameterType(parameter, index, List.class, NbtCompound.class);
                }
            }

            @Override
            public Object call(ReferenceResolver referenceResolver, DollarPart ... parameters) throws IllegalDollarFunctionParameterException, DollarEvaluationException {
                Object[] values = new Object[parameters.length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = parameters[i].evaluate(referenceResolver);
                }
                if (values[0] instanceof List) {
                    ArrayList result = new ArrayList((List)values[0]);
                    for (int i = 1; i < values.length; ++i) {
                        if (values[i] instanceof List) {
                            result.addAll((List)values[i]);
                            continue;
                        }
                        this.exceptParameterType(values[i], i, List.class);
                    }
                    return result;
                }
                if (values[0] instanceof NbtCompound) {
                    NbtCompound result = ((NbtCompound)values[0]).copy();
                    for (int i = 1; i < values.length; ++i) {
                        if (values[i] instanceof NbtCompound) {
                            result.copyFrom((NbtCompound)values[i]);
                            continue;
                        }
                        this.exceptParameterType(values[i], i, NbtCompound.class);
                    }
                }
                this.exceptParameterType(values[0], 0, List.class, NbtCompound.class);
                return null;
            }
        });
        DollarFunctions.register(new StaticDollarFunction("any", (Class[][])new Class[][]{{List.class}, {DollarFunction.class}}){

            @Override
            protected Object apply(Object[] parameters, ReferenceResolver referenceResolver) throws DollarEvaluationException, IllegalDollarFunctionParameterException {
                List list = (List)parameters[0];
                DollarFunction filter = (DollarFunction)parameters[1];
                for (Object value : list) {
                    if (!DollarUtil.asBoolean(filter.callDirect(referenceResolver, value))) continue;
                    return true;
                }
                return false;
            }
        });
        DollarFunctions.register(new StaticDollarFunction("all", (Class[][])new Class[][]{{List.class}, {DollarFunction.class}}){

            @Override
            protected Object apply(Object[] parameters, ReferenceResolver referenceResolver) throws DollarEvaluationException, IllegalDollarFunctionParameterException {
                List list = (List)parameters[0];
                DollarFunction filter = (DollarFunction)parameters[1];
                for (Object value : list) {
                    if (DollarUtil.asBoolean(filter.callDirect(referenceResolver, value))) continue;
                    return false;
                }
                return true;
            }
        });
        DollarFunctions.register(new StaticDollarFunction("mod", (Class[][])new Class[][]{{Number.class}, {Number.class}}){

            @Override
            protected Object apply(Object[] parameters, ReferenceResolver referenceResolver) throws DollarEvaluationException {
                long a = ((Number)parameters[0]).longValue();
                long b = ((Number)parameters[1]).longValue();
                if (b == 0L) {
                    throw new DollarEvaluationException("Division by zero");
                }
                if (b < 0L) {
                    throw new DollarEvaluationException("Modulo by negative number");
                }
                long m = a % b;
                if (m < 0L) {
                    return m + b;
                }
                return m;
            }
        });
        DollarFunctions.register(new StaticDollarFunction("abs", (Class[][])new Class[][]{{Number.class}}){

            @Override
            protected Object apply(Object[] parameters, ReferenceResolver referenceResolver) {
                Number n = (Number)parameters[0];
                if (n.doubleValue() < 0.0) {
                    return NumberUtil.negate(n);
                }
                return n;
            }
        });
        DollarFunctions.register(new StaticDollarFunction("power", (Class[][])new Class[][]{{Number.class}, {Number.class}}){

            @Override
            protected Object apply(Object[] parameters, ReferenceResolver referenceResolver) {
                return Math.pow(((Number)parameters[0]).doubleValue(), ((Number)parameters[1]).doubleValue());
            }
        });
        DollarFunctions.register(new VariadicNumericDollarFunction("min", Double.MAX_VALUE, (a, b) -> a.doubleValue() < b.doubleValue() ? (Number)((Number)a) : (Number)((Number)b)));
        DollarFunctions.register(new VariadicNumericDollarFunction("max", Double.MAX_VALUE, (a, b) -> a.doubleValue() > b.doubleValue() ? (Number)((Number)a) : (Number)((Number)b)));
    }
}

