/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar.function;

import de.siphalor.nbtcrafting3.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.exception.IllegalDollarFunctionParameterException;
import de.siphalor.nbtcrafting3.dollar.function.DollarFunction;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NbtCompound;
import org.apache.commons.lang3.ArrayUtils;

public abstract class StaticDollarFunction
extends DollarFunction {
    private final Class<?>[][] parameterClasses;
    private final int minParameters;

    public StaticDollarFunction(String name, int minParameters, Class<?>[] ... parameterClasses) {
        super(name);
        this.minParameters = minParameters;
        this.parameterClasses = parameterClasses;
    }

    public StaticDollarFunction(String name, Class<?>[] ... parameterClasses) {
        this(name, parameterClasses.length, parameterClasses);
    }

    @Override
    public boolean isParameterCountCorrect(int parameterCount) {
        return parameterCount >= this.minParameters && parameterCount <= this.parameterClasses.length;
    }

    @Override
    public void checkParameter(int index, Object parameter) throws IllegalDollarFunctionParameterException {
        Object[] classes = this.parameterClasses[index];
        if (classes.length == 0) {
            return;
        }
        if (parameter == null) {
            if (ArrayUtils.contains((Object[])classes, null)) {
                return;
            }
            this.exceptParameterType(null, index, (Class<?>[])classes);
        }
        if (parameter.getClass() == ItemStack.class && !ArrayUtils.contains((Object[])classes, ItemStack.class) && ArrayUtils.contains((Object[])classes, NbtCompound.class)) {
            parameter = NbtUtil.getTagOrEmpty((ItemStack)parameter);
        }
        boolean matching = false;
        for (Object parameterClass : classes) {
            if (!((Class)parameterClass).isAssignableFrom(parameter.getClass())) continue;
            matching = true;
            break;
        }
        if (!matching) {
            this.exceptParameterType(parameter, index, (Class<?>[])classes);
        }
    }

    @Override
    public Object call(ReferenceResolver referenceResolver, DollarPart ... parameters) throws DollarEvaluationException, IllegalDollarFunctionParameterException {
        Object[] parameterValues = new Object[parameters.length];
        for (int p = 0; p < parameters.length; ++p) {
            parameterValues[p] = parameters[p].evaluate(referenceResolver);
            this.checkParameter(p, parameterValues[p]);
        }
        return this.apply(parameterValues, referenceResolver);
    }

    protected abstract Object apply(Object[] var1, ReferenceResolver var2) throws DollarEvaluationException, IllegalDollarFunctionParameterException;
}

