/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar.function;

import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.exception.IllegalDollarFunctionParameterException;
import de.siphalor.nbtcrafting3.dollar.function.DollarFunction;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;
import de.siphalor.nbtcrafting3.util.NumberUtil;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.nbt.AbstractNbtNumber;

public class VariadicNumericDollarFunction
extends DollarFunction {
    private final Number start;
    private final BiFunction<Number, Number, Number> reduce;

    public VariadicNumericDollarFunction(String name, Number start, BiFunction<Number, Number, Number> reduce) {
        super(name);
        this.start = start;
        this.reduce = reduce;
    }

    @Override
    public boolean isParameterCountCorrect(int parameterCount) {
        return parameterCount > 0;
    }

    @Override
    public void checkParameter(int index, Object parameter) throws IllegalDollarFunctionParameterException {
        if (!(parameter instanceof Number) && !(parameter instanceof List) && parameter != null) {
            this.exceptParameterType(parameter, index, Number.class, List.class, null);
        }
    }

    @Override
    public Object call(ReferenceResolver referenceResolver, DollarPart ... parameters) throws DollarEvaluationException, IllegalDollarFunctionParameterException {
        Number value = this.start;
        for (int p = 0; p < parameters.length; ++p) {
            Object parameter = parameters[p].evaluate(referenceResolver);
            if (parameter == null) {
                parameter = NumberUtil.denullify(null);
            }
            if (parameter instanceof Number) {
                value = this.reduce.apply(value, (Number)parameter);
                continue;
            }
            if (parameter instanceof List) {
                for (Object element : (List)parameter) {
                    if (element instanceof AbstractNbtNumber) {
                        value = this.reduce.apply(value, ((AbstractNbtNumber)element).numberValue());
                        continue;
                    }
                    if (element instanceof Number) {
                        value = this.reduce.apply(value, (Number)element);
                        continue;
                    }
                    this.exceptParameterType(element, p, Number.class);
                }
                continue;
            }
            this.exceptParameterType(parameter, p, Number.class, List.class);
        }
        return value;
    }
}

