/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar.part.binary;

import de.siphalor.nbtcrafting3.dollar.DollarUtil;
import de.siphalor.nbtcrafting3.dollar.exception.DollarDeserializationException;
import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ConstantDollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ValueDollarPart;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;

public class CastDollarOperator
implements DollarPart {
    private final DollarPart dollarPart;
    private final int typeId;

    private CastDollarOperator(DollarPart dollarPart, int typeId) {
        this.dollarPart = dollarPart;
        this.typeId = typeId;
    }

    public static DollarPart of(DollarPart dollarPart, int typeId) throws DollarDeserializationException {
        CastDollarOperator instance = new CastDollarOperator(dollarPart, typeId);
        if (dollarPart instanceof ConstantDollarPart) {
            try {
                return ValueDollarPart.of(instance.evaluate(null));
            }
            catch (DollarEvaluationException e) {
                throw new DollarDeserializationException("Failed to short-circuit cast operator: " + e.getMessage(), e);
            }
        }
        return instance;
    }

    @Override
    public Object evaluate(ReferenceResolver referenceResolver) throws DollarEvaluationException {
        Object value = this.dollarPart.evaluate(referenceResolver);
        switch (this.typeId) {
            case 68: 
            case 100: {
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                if (value instanceof String) {
                    return Double.parseDouble((String)value);
                }
                if (value instanceof Boolean) {
                    return (Boolean)value != false ? 1.0 : 0.0;
                }
                throw new DollarEvaluationException("Failed to cast " + value + " to double");
            }
            case 70: 
            case 102: {
                if (value instanceof Number) {
                    return Float.valueOf(((Number)value).floatValue());
                }
                if (value instanceof String) {
                    return Float.valueOf(Float.parseFloat((String)value));
                }
                if (value instanceof Boolean) {
                    return Float.valueOf((Boolean)value != false ? 1.0f : 0.0f);
                }
                throw new DollarEvaluationException("Failed to cast " + value + " to float");
            }
            case 66: 
            case 67: 
            case 98: 
            case 99: {
                if (value instanceof Number) {
                    return ((Number)value).byteValue();
                }
                if (value instanceof String) {
                    return Byte.parseByte((String)value);
                }
                if (value instanceof Boolean) {
                    return (Boolean)value != false ? (byte)1 : 0;
                }
                throw new DollarEvaluationException("Failed to cast " + value + " to byte");
            }
            case 83: 
            case 115: {
                if (value instanceof Number) {
                    return ((Number)value).shortValue();
                }
                if (value instanceof String) {
                    return Short.parseShort((String)value);
                }
                if (value instanceof Boolean) {
                    return (Boolean)value != false ? (short)1 : 0;
                }
                throw new DollarEvaluationException("Failed to cast " + value + " to short");
            }
            case 73: 
            case 105: {
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                if (value instanceof String) {
                    return Integer.parseInt((String)value);
                }
                if (value instanceof Boolean) {
                    return (Boolean)value != false ? 1 : 0;
                }
                throw new DollarEvaluationException("Failed to cast " + value + " to int");
            }
            case 76: 
            case 108: {
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                if (value instanceof String) {
                    return Long.parseLong((String)value);
                }
                if (value instanceof Boolean) {
                    return (Boolean)value != false ? 1L : 0L;
                }
                throw new DollarEvaluationException("Failed to cast " + value + " to long");
            }
            case 111: {
                return DollarUtil.asBoolean(value);
            }
            case 97: {
                return value.toString();
            }
            case 110: {
                if (value instanceof Number) {
                    return value;
                }
                if (value instanceof Boolean) {
                    return (Boolean)value != false ? (byte)1 : 0;
                }
                if (value == null) {
                    return 0;
                }
                throw new DollarEvaluationException("Failed to cast " + DollarUtil.asString(value) + " to generic number");
            }
        }
        throw new DollarEvaluationException("Unknown cast type identifier " + new String(new int[]{this.typeId}, 0, 0));
    }
}

