/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar.part.binary;

import de.siphalor.nbtcrafting3.dollar.DollarUtil;
import de.siphalor.nbtcrafting3.dollar.exception.DollarDeserializationException;
import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.part.binary.BinaryDollarOperator;
import de.siphalor.nbtcrafting3.util.NumberUtil;
import org.apache.commons.lang3.StringUtils;

public class ProductDollarOperator
extends BinaryDollarOperator {
    private ProductDollarOperator(DollarPart first, DollarPart second) {
        super(first, second);
    }

    public static DollarPart of(DollarPart first, DollarPart second) throws DollarDeserializationException {
        return ProductDollarOperator.shortCircuitConstant(new ProductDollarOperator(first, second));
    }

    @Override
    public Object apply(Object first, Object second) throws DollarEvaluationException {
        if (first instanceof Number || first == null) {
            first = NumberUtil.denullify((Number)first);
            if (second instanceof Number || second == null) {
                return NumberUtil.product((Number)first, (Number)second);
            }
            if (second instanceof String) {
                return StringUtils.repeat((String)second.toString(), (int)((Number)first).intValue());
            }
        } else if (first instanceof String && (second instanceof Number || second == null)) {
            return StringUtils.repeat((String)first.toString(), (int)NumberUtil.denullify((Number)second).intValue());
        }
        throw new DollarEvaluationException("Invalid types for product: " + DollarUtil.asString(first) + " and " + DollarUtil.asString(second));
    }
}

