/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar.part.binary;

import de.siphalor.nbtcrafting3.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting3.dollar.exception.DollarDeserializationException;
import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.part.binary.BinaryDollarOperator;
import de.siphalor.nbtcrafting3.util.NumberUtil;
import net.minecraft.nbt.NbtCompound;

public class SumDollarOperator
extends BinaryDollarOperator {
    private SumDollarOperator(DollarPart first, DollarPart second) {
        super(first, second);
    }

    public static DollarPart of(DollarPart first, DollarPart second) throws DollarDeserializationException {
        return SumDollarOperator.shortCircuitConstant(new SumDollarOperator(first, second));
    }

    @Override
    public Object apply(Object first, Object second) throws DollarEvaluationException {
        if ((first instanceof Number || first == null) && (second instanceof Number || second == null)) {
            return NumberUtil.sum((Number)first, (Number)second);
        }
        if (first instanceof NbtCompound && second instanceof NbtCompound) {
            NbtCompound result = ((NbtCompound)first).copy();
            NbtUtil.mergeInto(result, (NbtCompound)second, true);
            return result;
        }
        return "" + first + second;
    }
}

