/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar.part.unary;

import de.siphalor.nbtcrafting3.dollar.exception.DollarDeserializationException;
import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ConstantDollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ValueDollarPart;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;

public abstract class UnaryDollarOperator
implements DollarPart {
    DollarPart dollarPart;

    public UnaryDollarOperator(DollarPart dollarPart) {
        this.dollarPart = dollarPart;
    }

    @Override
    public final Object evaluate(ReferenceResolver referenceResolver) throws DollarEvaluationException {
        return this.apply(this.dollarPart.evaluate(referenceResolver));
    }

    public abstract Object apply(Object var1) throws DollarEvaluationException;

    protected static DollarPart shortCircuitConstant(UnaryDollarOperator operator) throws DollarDeserializationException {
        if (operator.dollarPart instanceof ConstantDollarPart) {
            try {
                return ValueDollarPart.of(operator.apply(((ConstantDollarPart)operator.dollarPart).getConstantValue()));
            }
            catch (DollarEvaluationException e) {
                throw new DollarDeserializationException("Failed to short-circuit dollar operator " + operator.getClass().getSimpleName(), e);
            }
        }
        return operator;
    }
}

