/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar.part.value;

import de.siphalor.nbtcrafting3.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting3.dollar.exception.DollarDeserializationException;
import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ConstantDollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ValueDollarPart;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.util.Pair;

public class ObjectConstructDollarPart
implements DollarPart {
    private final Pair<String, DollarPart>[] properties;

    private ObjectConstructDollarPart(Pair<String, DollarPart>[] properties) {
        this.properties = properties;
    }

    @SafeVarargs
    public static DollarPart of(Pair<String, DollarPart> ... properties) throws DollarDeserializationException {
        ObjectConstructDollarPart instance = new ObjectConstructDollarPart(properties);
        for (Pair<String, DollarPart> property : properties) {
            if (property.getRight() instanceof ConstantDollarPart) continue;
            return instance;
        }
        try {
            return ValueDollarPart.of(instance.evaluate(null));
        }
        catch (DollarEvaluationException e) {
            throw new DollarDeserializationException("Failed to short-circuit dollar object construct", e);
        }
    }

    @Override
    public Object evaluate(ReferenceResolver referenceResolver) throws DollarEvaluationException {
        NbtCompound compound = new NbtCompound();
        for (Pair<String, DollarPart> property : this.properties) {
            compound.put((String)property.getLeft(), NbtUtil.asTag(((DollarPart)property.getRight()).evaluate(referenceResolver)));
        }
        return compound;
    }
}

