/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.ingredient;

import com.google.gson.JsonElement;
import de.siphalor.nbtcrafting3.api.RecipeUtil;
import de.siphalor.nbtcrafting3.dollar.Dollar;
import de.siphalor.nbtcrafting3.dollar.DollarExtractor;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketByteBuf;

public abstract class IngredientEntry {
    protected ItemStack remainder = null;
    protected Dollar[] remainderDollars = new Dollar[0];

    public abstract boolean matches(ItemStack var1);

    public abstract JsonElement toJson();

    public Collection<ItemStack> getPreviewStacks() {
        return this.getPreviewStacks(true);
    }

    public abstract Collection<ItemStack> getPreviewStacks(boolean var1);

    public abstract void write(PacketByteBuf var1);

    public ItemStack getRecipeRemainder(ItemStack stack, ReferenceResolver referenceResolver) {
        if (this.remainder == null) {
            return ItemStack.EMPTY;
        }
        return RecipeUtil.applyDollars(this.remainder.copy(), this.remainderDollars, referenceResolver);
    }

    public void setRecipeRemainder(ItemStack stack) {
        this.remainder = stack;
        if (stack.hasTag()) {
            this.remainderDollars = DollarExtractor.extractDollars(stack.getTag(), true);
        }
    }
}

