/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.api.nbt.NbtException;
import de.siphalor.nbtcrafting3.api.nbt.NbtIterator;
import de.siphalor.nbtcrafting3.api.nbt.NbtNumberRange;
import de.siphalor.nbtcrafting3.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting3.dollar.DollarExtractor;
import de.siphalor.nbtcrafting3.dollar.DollarUtil;
import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.exception.UnresolvedDollarReferenceException;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtElement;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.util.Identifier;
import net.minecraft.util.JsonHelper;
import net.minecraft.util.Pair;
import net.minecraft.util.registry.Registry;

public class IngredientEntryCondition {
    public static final IngredientEntryCondition EMPTY = new IngredientEntryCondition(NbtUtil.EMPTY_COMPOUND, NbtUtil.EMPTY_COMPOUND);
    public NbtCompound requiredElements;
    public NbtCompound deniedElements;
    public List<Pair<String, DollarPart>> dollarPredicates;
    private NbtCompound previewTag;

    protected IngredientEntryCondition() {
        this.requiredElements = NbtUtil.EMPTY_COMPOUND;
        this.deniedElements = NbtUtil.EMPTY_COMPOUND;
        this.dollarPredicates = null;
    }

    public IngredientEntryCondition(NbtCompound requiredElements, NbtCompound deniedElements) {
        this.requiredElements = requiredElements;
        this.deniedElements = deniedElements;
    }

    public boolean matches(ItemStack stack) {
        if (!stack.hasTag()) {
            return this.requiredElements.isEmpty();
        }
        NbtCompound tag = stack.getTag();
        if (!this.deniedElements.isEmpty() && NbtUtil.compoundsOverlap(tag, this.deniedElements)) {
            return false;
        }
        if (!this.requiredElements.isEmpty() && !NbtUtil.isCompoundContained(this.requiredElements, tag)) {
            return false;
        }
        if (this.dollarPredicates != null && !this.dollarPredicates.isEmpty()) {
            for (Pair<String, DollarPart> predicate : this.dollarPredicates) {
                try {
                    if (DollarUtil.asBoolean(((DollarPart)predicate.getRight()).evaluate(ref -> {
                        if ("$".equals(ref)) {
                            return tag;
                        }
                        throw new UnresolvedDollarReferenceException(ref);
                    }))) continue;
                    return false;
                }
                catch (DollarEvaluationException e) {
                    NbtCrafting.logWarn("Failed to evaluate dollar predicate (" + (String)predicate.getLeft() + "): " + e.getMessage());
                }
            }
        }
        return true;
    }

    public void addToJson(JsonObject json) {
        if (this.requiredElements.getSize() > 0) {
            json.add("require", NbtUtil.toJson((NbtElement)this.requiredElements));
        }
        if (this.deniedElements.getSize() > 0) {
            json.add("deny", NbtUtil.toJson((NbtElement)this.deniedElements));
        }
        if (this.dollarPredicates != null && !this.dollarPredicates.isEmpty()) {
            JsonArray array = new JsonArray();
            for (Pair<String, DollarPart> condition : this.dollarPredicates) {
                array.add((String)condition.getLeft());
            }
            json.add("conditions", (JsonElement)array);
        }
    }

    public NbtCompound getPreviewTag() {
        if (this.previewTag == null) {
            this.previewTag = this.requiredElements.copy();
            ArrayList dollarRangeKeys = new ArrayList();
            NbtIterator.iterateTags((NbtElement)this.previewTag, (path, key, tag) -> {
                String text;
                if (NbtUtil.isString(tag) && (text = NbtUtil.asString(tag)).startsWith("$")) {
                    dollarRangeKeys.add(new Pair((Object)NbtUtil.splitPath(path + key), (Object)NbtNumberRange.ofString(text.substring(1)).getExample()));
                }
                return NbtIterator.Action.RECURSE;
            });
            for (Pair dollarRangeKey : dollarRangeKeys) {
                try {
                    NbtUtil.put((NbtElement)this.previewTag, (String[])dollarRangeKey.getLeft(), (NbtElement)dollarRangeKey.getRight());
                }
                catch (NbtException e) {
                    NbtCrafting.logWarn("Failed to set dollar range value " + dollarRangeKey.getRight() + " for key " + String.join((CharSequence)".", (CharSequence[])dollarRangeKey.getLeft()) + " in preview tag " + this.previewTag);
                }
            }
        }
        return this.previewTag;
    }

    public static IngredientEntryCondition fromJson(JsonObject json) {
        Identifier potion;
        IngredientEntryCondition condition = new IngredientEntryCondition();
        boolean flatObject = true;
        if (json.has("require")) {
            if (!json.get("require").isJsonObject()) {
                throw new JsonParseException("data.require must be an object");
            }
            condition.requiredElements = (NbtCompound)NbtUtil.asTag((JsonElement)json.getAsJsonObject("require"));
            flatObject = false;
        }
        if (json.has("potion")) {
            potion = new Identifier(JsonHelper.getString((JsonObject)json, (String)"potion"));
            if (Registry.POTION.getOrEmpty(potion).isPresent()) {
                if (condition.requiredElements == NbtUtil.EMPTY_COMPOUND) {
                    condition.requiredElements = new NbtCompound();
                }
                condition.requiredElements.putString("Potion", potion.toString());
            } else {
                new JsonSyntaxException("Unknown potion '" + potion + "'").printStackTrace();
            }
            flatObject = false;
        }
        if (json.has("potion")) {
            potion = new Identifier(JsonHelper.getString((JsonObject)json, (String)"potion"));
            if (Registry.POTION.getOrEmpty(potion).isPresent()) {
                if (condition.requiredElements == NbtUtil.EMPTY_COMPOUND) {
                    condition.requiredElements = new NbtCompound();
                }
                condition.requiredElements.putString("Potion", potion.toString());
            } else {
                new JsonSyntaxException("Unknown potion '" + potion + "'").printStackTrace();
            }
            flatObject = false;
        }
        if (json.has("deny")) {
            if (!json.get("deny").isJsonObject()) {
                throw new JsonParseException("data.deny must be an object");
            }
            condition.deniedElements = (NbtCompound)NbtUtil.asTag((JsonElement)json.getAsJsonObject("deny"));
            flatObject = false;
        }
        if (json.has("conditions")) {
            if (!json.get("conditions").isJsonArray()) {
                throw new JsonParseException("data.conditions must be an array");
            }
            JsonArray array = json.getAsJsonArray("conditions");
            ArrayList<Pair<String, DollarPart>> predicates = new ArrayList<Pair<String, DollarPart>>(array.size());
            for (JsonElement jsonElement : array) {
                if (!JsonHelper.isString((JsonElement)jsonElement)) {
                    throw new JsonParseException("data.conditions must be an array of strings");
                }
                predicates.add((Pair<String, DollarPart>)new Pair((Object)jsonElement.getAsString(), (Object)DollarExtractor.parse(jsonElement.getAsString())));
            }
            condition.dollarPredicates = predicates;
            flatObject = false;
        }
        if (flatObject) {
            condition.requiredElements = (NbtCompound)NbtUtil.asTag((JsonElement)json);
        }
        return condition;
    }

    public void write(PacketByteBuf buf) {
        buf.writeNbt(this.requiredElements);
        buf.writeNbt(this.deniedElements);
    }

    public static IngredientEntryCondition read(PacketByteBuf buf) {
        return new IngredientEntryCondition(buf.readNbt(), buf.readNbt());
    }
}

