/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.siphalor.nbtcrafting3.ingredient.IngredientEntry;
import de.siphalor.nbtcrafting3.ingredient.IngredientEntryCondition;
import de.siphalor.nbtcrafting3.util.duck.IItemStack;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.util.registry.Registry;

public class IngredientMultiStackEntry
extends IngredientEntry {
    private final IngredientEntryCondition condition;
    private final IntList itemIds;
    private String tag;

    public IngredientMultiStackEntry(Collection<Integer> items, IngredientEntryCondition condition) {
        this.condition = condition;
        this.itemIds = new IntArrayList(items);
        this.tag = "";
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.itemIds.contains(Registry.ITEM.getRawId((Object)stack.getItem())) && this.condition.matches(stack);
    }

    @Override
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("tag", this.tag);
        this.condition.addToJson(json);
        return json;
    }

    @Override
    public Collection<ItemStack> getPreviewStacks(boolean nbt) {
        NbtCompound tag = this.condition.getPreviewTag();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(this.itemIds.size());
        for (Integer id : this.itemIds) {
            ItemStack stack = new ItemStack((ItemConvertible)Registry.ITEM.get(id.intValue()));
            stacks.add(stack);
        }
        if (nbt) {
            for (ItemStack itemStack : stacks) {
                ((IItemStack)itemStack).nbtCrafting$setRawTag(tag);
            }
        }
        return stacks;
    }

    @Override
    public void write(PacketByteBuf buf) {
        buf.writeVarInt(this.itemIds.size());
        for (int i = 0; i < this.itemIds.size(); ++i) {
            buf.writeVarInt(this.itemIds.getInt(i));
        }
        this.condition.write(buf);
        buf.writeBoolean(this.remainder != null);
        if (this.remainder != null) {
            buf.writeItemStack(this.remainder);
        }
    }

    public static IngredientMultiStackEntry read(PacketByteBuf buf) {
        int length = buf.readVarInt();
        ArrayList<Integer> ids = new ArrayList<Integer>(length);
        for (int i = 0; i < length; ++i) {
            ids.add(buf.readVarInt());
        }
        IngredientMultiStackEntry entry = new IngredientMultiStackEntry(ids, IngredientEntryCondition.read(buf));
        if (buf.readBoolean()) {
            entry.setRecipeRemainder(buf.readItemStack());
        }
        return entry;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}

