/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.siphalor.nbtcrafting3.ingredient.IngredientEntry;
import de.siphalor.nbtcrafting3.ingredient.IngredientEntryCondition;
import de.siphalor.nbtcrafting3.util.duck.IItemStack;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.util.registry.Registry;

public class IngredientStackEntry
extends IngredientEntry {
    private final IngredientEntryCondition condition;
    private final int id;

    public IngredientStackEntry(int id, IngredientEntryCondition condition) {
        this.id = id;
        this.condition = condition;
    }

    public IngredientStackEntry(ItemStack stack) {
        this.id = Registry.ITEM.getRawId((Object)stack.getItem());
        this.condition = stack.hasTag() ? new IngredientEntryCondition(stack.getTag(), new NbtCompound()) : new IngredientEntryCondition();
    }

    @Override
    public boolean matches(ItemStack stack) {
        return Registry.ITEM.getRawId((Object)stack.getItem()) == this.id && this.condition.matches(stack);
    }

    @Override
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("item", Registry.ITEM.getId((Object)((Item)Registry.ITEM.get(this.id))).toString());
        this.condition.addToJson(json);
        return json;
    }

    @Override
    public Collection<ItemStack> getPreviewStacks(boolean nbt) {
        ItemStack stack = new ItemStack((ItemConvertible)Registry.ITEM.get(this.id));
        if (nbt) {
            ((IItemStack)stack).nbtCrafting$setRawTag(this.condition.getPreviewTag());
        }
        return Collections.singleton(stack);
    }

    @Override
    public void write(PacketByteBuf buf) {
        buf.writeVarInt(this.id);
        this.condition.write(buf);
        buf.writeBoolean(this.remainder != null);
        if (this.remainder != null) {
            buf.writeItemStack(this.remainder);
        }
    }

    public static IngredientStackEntry read(PacketByteBuf buf) {
        IngredientStackEntry entry = new IngredientStackEntry(buf.readVarInt(), IngredientEntryCondition.read(buf));
        if (buf.readBoolean()) {
            entry.setRecipeRemainder(buf.readItemStack());
        }
        return entry;
    }
}

