/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.mixin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.api.JsonPreprocessor;
import de.siphalor.nbtcrafting3.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;
import de.siphalor.nbtcrafting3.ingredient.IIngredient;
import de.siphalor.nbtcrafting3.ingredient.IngredientEntry;
import de.siphalor.nbtcrafting3.ingredient.IngredientEntryCondition;
import de.siphalor.nbtcrafting3.ingredient.IngredientMultiStackEntry;
import de.siphalor.nbtcrafting3.ingredient.IngredientStackEntry;
import de.siphalor.nbtcrafting3.util.duck.ICloneable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.StringNbtReader;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.recipe.Ingredient;
import net.minecraft.recipe.ShapedRecipe;
import net.minecraft.tag.ItemTags;
import net.minecraft.tag.Tag;
import net.minecraft.util.Identifier;
import net.minecraft.util.JsonHelper;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.Registry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Ingredient.class}, priority=990)
public abstract class MixinIngredient
implements IIngredient,
ICloneable {
    @Shadow
    private ItemStack[] matchingStacks;
    @Unique
    private IngredientEntry[] advancedEntries;

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstruct(Stream stream, CallbackInfo ci) {
        this.advancedEntries = null;
    }

    @Inject(method={"cacheMatchingStacks"}, at={@At(value="HEAD")}, cancellable=true)
    private void createStackArray(CallbackInfo callbackInfo) {
        if (this.advancedEntries != null) {
            callbackInfo.cancel();
            if (this.matchingStacks == null || this.matchingStacks.length == 0) {
                this.matchingStacks = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? (ItemStack[])Arrays.stream(this.advancedEntries).flatMap(entry -> entry.getPreviewStacks(true).stream()).distinct().toArray(ItemStack[]::new) : (ItemStack[])Arrays.stream(this.advancedEntries).flatMap(entry -> entry.getPreviewStacks(false).stream()).distinct().toArray(ItemStack[]::new);
                if (this.matchingStacks.length == 0) {
                    this.matchingStacks = new ItemStack[]{ItemStack.EMPTY};
                }
            }
        }
    }

    @Inject(method={"test"}, at={@At(value="HEAD")}, cancellable=true)
    public void matches(ItemStack stack, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (stack == null) {
            callbackInfoReturnable.setReturnValue((Object)false);
            return;
        }
        if (this.advancedEntries != null) {
            if (this.advancedEntries.length == 0) {
                callbackInfoReturnable.setReturnValue((Object)stack.isEmpty());
                return;
            }
            for (IngredientEntry advancedEntry : this.advancedEntries) {
                if (!advancedEntry.matches(stack)) continue;
                callbackInfoReturnable.setReturnValue((Object)true);
                return;
            }
            callbackInfoReturnable.setReturnValue((Object)false);
        }
    }

    @Inject(method={"write"}, at={@At(value="HEAD")}, cancellable=true)
    public void write(PacketByteBuf buf, CallbackInfo callbackInfo) {
        if (NbtCrafting.isAdvancedIngredientSerializationEnabled()) {
            if (this.advancedEntries != null && this.advancedEntries.length != 0) {
                buf.writeVarInt(this.advancedEntries.length);
                for (IngredientEntry entry : this.advancedEntries) {
                    buf.writeBoolean(entry instanceof IngredientMultiStackEntry);
                    entry.write(buf);
                }
                callbackInfo.cancel();
            } else {
                buf.writeVarInt(-1);
            }
        }
    }

    @Inject(method={"toJson"}, at={@At(value="HEAD")}, cancellable=true)
    public void toJson(CallbackInfoReturnable<JsonElement> callbackInfoReturnable) {
        if (this.advancedEntries != null) {
            if (this.advancedEntries.length == 1) {
                callbackInfoReturnable.setReturnValue((Object)this.advancedEntries[0].toJson());
                return;
            }
            JsonArray array = new JsonArray();
            for (IngredientEntry advancedEntry : this.advancedEntries) {
                array.add(advancedEntry.toJson());
            }
            callbackInfoReturnable.setReturnValue((Object)array);
        }
    }

    @Inject(method={"isEmpty"}, at={@At(value="HEAD")}, cancellable=true)
    public void isEmpty(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (this.advancedEntries != null) {
            callbackInfoReturnable.setReturnValue((Object)(this.advancedEntries.length == 0 ? 1 : 0));
        }
    }

    @Unique
    private static Ingredient ofAdvancedEntries(Stream<? extends IngredientEntry> entries) {
        if (entries == null) {
            NbtCrafting.logError("Internal error: can't construct ingredient from null entry stream!");
        }
        try {
            Ingredient ingredient = (Ingredient)((ICloneable)Ingredient.EMPTY).clone();
            ((IIngredient)ingredient).nbtCrafting$setAdvancedEntries(entries);
            return ingredient;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return Ingredient.EMPTY;
        }
    }

    @Inject(method={"fromPacket"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fromPacket(PacketByteBuf buf, CallbackInfoReturnable<Ingredient> cir) {
        int length;
        if (NbtCrafting.isAdvancedIngredientSerializationEnabled() && (length = buf.readVarInt()) >= 0) {
            ArrayList<IngredientEntry> entries = new ArrayList<IngredientEntry>(length);
            for (int i = 0; i < length; ++i) {
                if (buf.readBoolean()) {
                    entries.add(IngredientMultiStackEntry.read(buf));
                    continue;
                }
                entries.add(IngredientStackEntry.read(buf));
            }
            cir.setReturnValue((Object)MixinIngredient.ofAdvancedEntries(entries.stream()));
        }
    }

    @Inject(method={"fromJson"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fromJson(JsonElement element, CallbackInfoReturnable<Ingredient> callbackInfoReturnable) {
        if (!NbtCrafting.isAdvancedIngredientSerializationEnabled()) {
            return;
        }
        if (element == null || element.isJsonNull()) {
            throw new JsonSyntaxException("Item cannot be null");
        }
        if (element.isJsonObject()) {
            if (element.getAsJsonObject().has("data") || element.getAsJsonObject().has("remainder") || element.getAsJsonObject().has("potion")) {
                callbackInfoReturnable.setReturnValue((Object)MixinIngredient.ofAdvancedEntries(Stream.of(MixinIngredient.advancedEntryFromJson(element.getAsJsonObject()))));
            }
        } else if (element.isJsonArray()) {
            JsonArray jsonArray = element.getAsJsonArray();
            boolean containsCustomData = false;
            for (JsonElement jsonElement : jsonArray) {
                JsonObject jsonObject;
                if (!jsonElement.isJsonObject() || !(jsonObject = jsonElement.getAsJsonObject()).has("data") && !jsonObject.has("remainder") && !jsonObject.has("potion")) continue;
                containsCustomData = true;
                break;
            }
            if (containsCustomData) {
                if (jsonArray.size() == 0) {
                    throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
                }
                callbackInfoReturnable.setReturnValue((Object)MixinIngredient.ofAdvancedEntries(StreamSupport.stream(jsonArray.spliterator(), false).map(e -> MixinIngredient.advancedEntryFromJson(JsonHelper.asObject((JsonElement)e, (String)"item")))));
            }
        }
    }

    @Unique
    private static IngredientEntry advancedEntryFromJson(JsonObject jsonObject) {
        if (jsonObject.has("item") && jsonObject.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item or a potion, not both");
        }
        if (jsonObject.has("item")) {
            Identifier itemId = new Identifier(JsonHelper.getString((JsonObject)jsonObject, (String)"item"));
            try {
                Item item = (Item)Registry.ITEM.getOrEmpty(itemId).orElseThrow(() -> {
                    throw new JsonSyntaxException("Unknown item '" + itemId + "'");
                });
                IngredientStackEntry entry = new IngredientStackEntry(Registry.ITEM.getRawId((Object)item), MixinIngredient.loadIngredientEntryCondition(jsonObject));
                if (jsonObject.has("remainder")) {
                    entry.setRecipeRemainder(ShapedRecipe.outputFromJson((JsonObject)JsonHelper.getObject((JsonObject)jsonObject, (String)"remainder")));
                }
                return entry;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        if (jsonObject.has("tag")) {
            Identifier tagId = new Identifier(JsonHelper.getString((JsonObject)jsonObject, (String)"tag"));
            Tag tag = ItemTags.getTagGroup().getTag(tagId);
            if (tag == null) {
                throw new JsonSyntaxException("Unknown item tag '" + tagId + "'");
            }
            IngredientMultiStackEntry entry = new IngredientMultiStackEntry(tag.values().stream().map(arg_0 -> ((DefaultedRegistry)Registry.ITEM).getRawId(arg_0)).collect(Collectors.toList()), MixinIngredient.loadIngredientEntryCondition(jsonObject));
            entry.setTag(tagId.toString());
            if (jsonObject.has("remainder")) {
                entry.setRecipeRemainder(ShapedRecipe.outputFromJson((JsonObject)JsonHelper.getObject((JsonObject)jsonObject, (String)"remainder")));
            }
            return entry;
        }
        if (jsonObject.has("potion")) {
            IngredientEntryCondition condition = MixinIngredient.loadIngredientEntryCondition(jsonObject);
            IngredientStackEntry entry = new IngredientStackEntry(Registry.ITEM.getRawId((Object)Items.POTION), condition);
            if (jsonObject.has("remainder")) {
                entry.setRecipeRemainder(ShapedRecipe.outputFromJson((JsonObject)JsonHelper.getObject((JsonObject)jsonObject, (String)"remainder")));
            }
            return entry;
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item or a potion");
    }

    @Unique
    private static IngredientEntryCondition loadIngredientEntryCondition(JsonObject jsonObject) {
        if (jsonObject.has("data")) {
            if (JsonHelper.hasString((JsonObject)jsonObject, (String)"data")) {
                try {
                    NbtCompound compoundTag = new StringNbtReader(new StringReader(jsonObject.get("data").getAsString())).parseCompound();
                    return new IngredientEntryCondition(compoundTag, NbtUtil.EMPTY_COMPOUND);
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            } else if (jsonObject.get("data").isJsonObject()) {
                return IngredientEntryCondition.fromJson((JsonObject)JsonPreprocessor.process((JsonElement)jsonObject.get("data").getAsJsonObject()));
            }
        }
        return IngredientEntryCondition.EMPTY;
    }

    @Override
    public boolean nbtCrafting3$isAdvanced() {
        return this.advancedEntries != null;
    }

    @Override
    public void nbtCrafting$setAdvancedEntries(Stream<? extends IngredientEntry> entries) {
        this.advancedEntries = (IngredientEntry[])entries.filter(Objects::nonNull).toArray(IngredientEntry[]::new);
    }

    @Override
    public ItemStack nbtCrafting3$getRecipeRemainder(ItemStack stack, ReferenceResolver referenceResolver) {
        if (this.advancedEntries != null) {
            for (IngredientEntry entry : this.advancedEntries) {
                ItemStack remainder;
                if (!entry.matches(stack) || (remainder = entry.getRecipeRemainder(stack, referenceResolver)) == null) continue;
                return remainder;
            }
        }
        return null;
    }
}

