/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.mixin;

import de.siphalor.nbtcrafting3.api.RecipeUtil;
import de.siphalor.nbtcrafting3.api.recipe.NBTCRecipe;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;
import de.siphalor.nbtcrafting3.ingredient.IIngredient;
import java.util.ArrayList;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.recipe.Ingredient;
import net.minecraft.recipe.Recipe;
import net.minecraft.util.collection.DefaultedList;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Recipe.class})
public interface MixinRecipe {
    @Shadow
    public DefaultedList<Ingredient> getIngredients();

    @Overwrite
    default public DefaultedList<ItemStack> getRemainder(Inventory inventory) {
        int[] resolvedIngredientStacks;
        ReferenceResolver referenceResolver;
        Object ingredients;
        DefaultedList stackList = DefaultedList.ofSize((int)inventory.size(), (Object)ItemStack.EMPTY);
        if (this instanceof NBTCRecipe) {
            ingredients = new ArrayList(((NBTCRecipe)((Object)this)).getIngredients());
            referenceResolver = ((NBTCRecipe)((Object)this)).getReferenceResolver(inventory);
            resolvedIngredientStacks = RecipeUtil.resolveIngredients(ingredients, inventory);
        } else {
            ingredients = this.getIngredients();
            resolvedIngredientStacks = RecipeUtil.resolveIngredients(ingredients, inventory);
            referenceResolver = RecipeUtil.buildReferenceResolverFromResolvedIngredients(resolvedIngredientStacks, inventory);
        }
        for (int i = 0; i < stackList.size(); ++i) {
            ItemStack remainder;
            ItemStack stack = inventory.getStack(i);
            int ingredientIndex = ArrayUtils.indexOf((int[])resolvedIngredientStacks, (int)i);
            if (ingredientIndex >= 0 && (remainder = ((IIngredient)ingredients.get(ingredientIndex)).nbtCrafting3$getRecipeRemainder(stack, referenceResolver)) != null) {
                stackList.set(i, (Object)remainder);
                continue;
            }
            if (!stack.getItem().hasRecipeRemainder()) continue;
            stackList.set(i, (Object)new ItemStack((ItemConvertible)stack.getItem().getRecipeRemainder()));
        }
        return stackList;
    }
}

