/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.mixin;

import de.siphalor.nbtcrafting3.NbtCrafting;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.BitSet;
import java.util.List;
import net.minecraft.recipe.Ingredient;
import net.minecraft.recipe.Recipe;
import net.minecraft.recipe.RecipeMatcher;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net/minecraft/recipe/RecipeMatcher$Matcher"})
public abstract class MixinRecipeFinder$Filter {
    @Shadow
    @Final
    private List<Ingredient> ingredients;
    @Shadow
    @Final
    private int[] requiredItems;
    @Shadow
    @Final
    private BitSet requirementsMatrix;
    @Unique
    private RecipeMatcher owner;

    @Shadow
    protected abstract int getRequirementIndex(boolean var1, int var2, int var3);

    @Inject(method={"<init>(Lnet/minecraft/recipe/RecipeMatcher;Lnet/minecraft/recipe/Recipe;)V"}, at={@At(value="RETURN")})
    public void onConstruct(RecipeMatcher recipeFinder, Recipe<?> recipe, CallbackInfo ci) {
        this.requirementsMatrix.clear();
        for (int j = 0; j < this.ingredients.size(); ++j) {
            Ingredient ingredient = this.ingredients.get(j);
            for (int i = 0; i < this.requiredItems.length; ++i) {
                if (!ingredient.test(RecipeMatcher.getStackFromId((int)this.requiredItems[i]))) continue;
                this.requirementsMatrix.set(this.getRequirementIndex(true, i, j));
            }
        }
    }

    @Overwrite
    private int[] createItemRequirementList() {
        this.owner = NbtCrafting.lastRecipeFinder;
        IntAVLTreeSet ints = new IntAVLTreeSet();
        IntIterator intIterator = this.owner.inputs.keySet().iterator();
        while (intIterator.hasNext()) {
            int id = (Integer)intIterator.next();
            for (Ingredient ingredient : this.ingredients) {
                if (!ingredient.test(RecipeMatcher.getStackFromId((int)id))) continue;
                ints.add(id);
            }
        }
        return ints.toIntArray();
    }

    @Overwrite
    private int getMaximumCrafts() {
        int result = Integer.MAX_VALUE;
        for (Ingredient ingredient : this.ingredients) {
            int maxPerIngredient = 0;
            IntIterator intIterator = this.owner.inputs.keySet().iterator();
            while (intIterator.hasNext()) {
                int id = (Integer)intIterator.next();
                if (!ingredient.test(RecipeMatcher.getStackFromId((int)id))) continue;
                maxPerIngredient = Math.max(maxPerIngredient, this.owner.inputs.get(id));
            }
            if (result <= 0) continue;
            result = Math.min(result, maxPerIngredient);
        }
        return result;
    }
}

