/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.mixin;

import com.mojang.datafixers.util.Pair;
import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting3.util.duck.IItemStack;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.concurrent.ExecutionException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.recipe.Recipe;
import net.minecraft.recipe.RecipeMatcher;
import net.minecraft.util.registry.Registry;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeMatcher.class})
public abstract class MixinRecipeFinder {
    @Shadow
    @Final
    public Int2IntMap inputs;

    @Shadow
    public abstract void addInput(ItemStack var1);

    @Unique
    private static Pair<Integer, NbtCompound> getStackPair(ItemStack stack) {
        return new Pair((Object)Registry.ITEM.getRawId((Object)stack.getItem()), (Object)NbtUtil.getTagOrEmpty(stack));
    }

    @Inject(method={"match(Lnet/minecraft/recipe/Recipe;Lit/unimi/dsi/fastutil/ints/IntList;I)Z"}, at={@At(value="HEAD")})
    public void onFindRecipe(Recipe recipe, IntList ints, int int_1, CallbackInfoReturnable<Boolean> ci) {
        NbtCrafting.lastRecipeFinder = (RecipeMatcher)this;
    }

    @Inject(method={"countCrafts(Lnet/minecraft/recipe/Recipe;ILit/unimi/dsi/fastutil/ints/IntList;)I"}, at={@At(value="HEAD")})
    public void onCountCrafts(Recipe recipe, int int_1, IntList ints, CallbackInfoReturnable<Integer> ci) {
        NbtCrafting.lastRecipeFinder = (RecipeMatcher)this;
    }

    @Overwrite
    public void addUnenchantedInput(ItemStack stack) {
        this.addInput(stack);
    }

    @Overwrite
    public static int getItemId(ItemStack stack) {
        int id = -1;
        if (stack.isEmpty()) {
            id = 0;
        } else {
            Pair<Integer, NbtCompound> stackPair = MixinRecipeFinder.getStackPair(stack);
            try {
                id = (Integer)NbtCrafting.stack2IdMap.get(stackPair);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public static ItemStack getStackFromId(int id) {
        Int2ObjectMap<Pair<Integer, NbtCompound>> int2ObjectMap = NbtCrafting.id2StackMap;
        synchronized (int2ObjectMap) {
            if (NbtCrafting.id2StackMap.containsKey(id)) {
                ItemStack result = new ItemStack((ItemConvertible)Item.byRawId((int)((Integer)((Pair)NbtCrafting.id2StackMap.get(id)).getFirst())));
                ((IItemStack)result).nbtCrafting$setRawTag((NbtCompound)((Pair)NbtCrafting.id2StackMap.get(id)).getSecond());
                return result;
            }
        }
        return ItemStack.EMPTY;
    }
}

