/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.mixin.anvil;

import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.recipe.AnvilRecipe;
import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.network.packet.s2c.play.ScreenHandlerSlotUpdateS2CPacket;
import net.minecraft.screen.AnvilScreenHandler;
import net.minecraft.screen.ForgingScreenHandler;
import net.minecraft.screen.Property;
import net.minecraft.screen.ScreenHandlerContext;
import net.minecraft.screen.ScreenHandlerType;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.text.LiteralText;
import net.minecraft.text.Text;
import net.minecraft.util.Identifier;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AnvilScreenHandler.class})
public abstract class MixinAnvilContainer
extends ForgingScreenHandler {
    @Shadow
    private String newItemName;
    @Shadow
    @Final
    private Property levelCost;
    @Shadow
    private int repairItemUsage;
    @Unique
    private boolean userChangedName = false;
    @Unique
    private ItemStack originalBaseStack;
    @Unique
    private AnvilRecipe recipe = null;

    public MixinAnvilContainer(@Nullable ScreenHandlerType<?> type, int syncId, PlayerInventory playerInventory, ScreenHandlerContext context) {
        super(type, syncId, playerInventory, context);
    }

    @Inject(method={"updateResult"}, at={@At(value="HEAD")}, cancellable=true)
    public void updateResult(CallbackInfo callbackInfo) {
        this.recipe = this.player.world.getRecipeManager().getFirstMatch(NbtCrafting.ANVIL_RECIPE_TYPE, this.input, this.player.world).orElse(null);
        if (this.recipe != null) {
            ItemStack resultStack = this.recipe.craft(this.input);
            this.repairItemUsage = 1;
            if (this.userChangedName) {
                if (!StringUtils.isBlank((CharSequence)this.newItemName) && !this.newItemName.equals(resultStack.getName().getString())) {
                    resultStack.setCustomName((Text)new LiteralText(this.newItemName));
                }
                this.userChangedName = false;
            } else {
                this.newItemName = resultStack.getName().getString();
                if (this.player instanceof ServerPlayerEntity && NbtCrafting.hasClientMod((ServerPlayerEntity)this.player)) {
                    PacketByteBuf packetByteBuf = new PacketByteBuf(Unpooled.buffer());
                    packetByteBuf.writeString(this.newItemName);
                    ServerPlayNetworking.send((ServerPlayerEntity)((ServerPlayerEntity)this.player), (Identifier)NbtCrafting.UPDATE_ANVIL_TEXT_S2C_PACKET_ID, (PacketByteBuf)packetByteBuf);
                }
            }
            this.output.setStack(0, resultStack);
            this.levelCost.set(this.recipe.getLevels());
            this.sendContentUpdates();
            callbackInfo.cancel();
        }
    }

    @Inject(method={"setNewItemName"}, at={@At(value="HEAD")})
    public void onNewItemNameSet(String newNewItemName, CallbackInfo callbackInfo) {
        this.userChangedName = true;
    }

    @Inject(method={"canTakeOutput"}, at={@At(value="HEAD")}, cancellable=true)
    public void canTakeItemsTop(PlayerEntity player, boolean present, CallbackInfoReturnable<Boolean> cir) {
        if (this.levelCost.get() <= 0) {
            ItemStack base = this.getSlot(0).getStack();
            if (!ItemStack.areItemsEqual((ItemStack)this.getSlot(2).getStack(), (ItemStack)base) || !ItemStack.areTagsEqual((ItemStack)this.getSlot(2).getStack(), (ItemStack)base)) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"onTakeOutput"}, at={@At(value="HEAD")})
    public void onTakeItemTop(PlayerEntity player, ItemStack stack, CallbackInfo ci) {
        this.originalBaseStack = this.getSlot(0).getStack();
    }

    @Inject(method={"onTakeOutput"}, at={@At(value="RETURN")})
    public void onItemTaken(PlayerEntity player, ItemStack stack, CallbackInfo ci) {
        if (this.recipe != null && this.originalBaseStack != null && !this.recipe.getBase().isEmpty()) {
            this.originalBaseStack.decrement(1);
            this.getSlot(0).setStack(this.originalBaseStack);
            stack.onCraft(player.world, player, stack.getCount());
        }
        if (player instanceof ServerPlayerEntity && !NbtCrafting.hasClientMod((ServerPlayerEntity)player)) {
            ((ServerPlayerEntity)player).networkHandler.sendPacket((Packet)new ScreenHandlerSlotUpdateS2CPacket(-1, this.nextRevision(), 0, stack));
        }
    }
}

