/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.mixin.brewing;

import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.client.NbtCraftingClient;
import de.siphalor.nbtcrafting3.mixin.RecipeManagerAccessor;
import de.siphalor.nbtcrafting3.recipe.BrewingRecipe;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.block.entity.BrewingStandBlockEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.recipe.BrewingRecipeRegistry;
import net.minecraft.screen.slot.Slot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net/minecraft/screen/BrewingStandScreenHandler$IngredientSlot"})
public abstract class MixinBrewingSlotIngredient
extends Slot {
    public MixinBrewingSlotIngredient(Inventory inventory_1, int int_1, int int_2, int int_3) {
        super(inventory_1, int_1, int_2, int_3);
    }

    @Inject(method={"canInsert(Lnet/minecraft/item/ItemStack;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    public void canInsert(ItemStack stack, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        RecipeManagerAccessor recipeManager;
        if (((Boolean)callbackInfoReturnable.getReturnValue()).booleanValue() || BrewingRecipeRegistry.isValidIngredient((ItemStack)stack)) {
            callbackInfoReturnable.setReturnValue((Object)true);
            return;
        }
        if (this.inventory instanceof BrewingStandBlockEntity) {
            recipeManager = (RecipeManagerAccessor)((BrewingStandBlockEntity)this.inventory).getWorld().getRecipeManager();
        } else if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            recipeManager = (RecipeManagerAccessor)NbtCraftingClient.getClientRecipeManager();
        } else {
            NbtCrafting.logError("Failed to get recipe manager in brewing stand container class!");
            return;
        }
        Map recipes = recipeManager.callGetAllOfType(NbtCrafting.BREWING_RECIPE_TYPE);
        callbackInfoReturnable.setReturnValue((Object)recipes.values().stream().anyMatch(recipe -> recipe instanceof BrewingRecipe && ((BrewingRecipe)recipe).getIngredient().test(stack)));
    }
}

