/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.mixin.brewing;

import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.api.RecipeUtil;
import de.siphalor.nbtcrafting3.recipe.BrewingRecipe;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.entity.BlockEntityType;
import net.minecraft.block.entity.BrewingStandBlockEntity;
import net.minecraft.block.entity.LockableContainerBlockEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.collection.DefaultedList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BrewingStandBlockEntity.class})
public abstract class MixinBrewingStandBlockEntity
extends LockableContainerBlockEntity {
    @Unique
    private static World lastWorld;
    @Unique
    private static BrewingStandBlockEntity lastBlockEntity;
    @Unique
    private static BlockPos lastBlockPos;

    protected MixinBrewingStandBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/entity/BrewingStandBlockEntity;canCraft(Lnet/minecraft/util/collection/DefaultedList;)Z")})
    private static void beforeCanCraft(World world, BlockPos blockPos, BlockState blockState, BrewingStandBlockEntity blockEntity, CallbackInfo callbackInfo) {
        lastWorld = world;
        lastBlockEntity = blockEntity;
        lastBlockPos = blockPos;
    }

    @Inject(method={"canCraft"}, at={@At(value="HEAD")}, cancellable=true)
    private static void canCraft(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        Optional recipe = lastWorld.getRecipeManager().getFirstMatch(NbtCrafting.BREWING_RECIPE_TYPE, (Inventory)lastBlockEntity, lastWorld);
        if (recipe.isPresent()) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
    }

    @Inject(method={"craft"}, at={@At(value="HEAD")}, cancellable=true)
    private static void craft(World world, BlockPos pos, DefaultedList<ItemStack> invList, CallbackInfo callbackInfo) {
        Optional recipe = lastWorld.getRecipeManager().getFirstMatch(NbtCrafting.BREWING_RECIPE_TYPE, (Inventory)lastBlockEntity, lastWorld);
        if (recipe.isPresent()) {
            DefaultedList<ItemStack> remainingStacks = ((BrewingRecipe)recipe.get()).getRemainder((Inventory)lastBlockEntity);
            ItemStack[] results = ((BrewingRecipe)recipe.get()).craftAll((Inventory)lastBlockEntity);
            lastBlockEntity.getStack(3).decrement(1);
            for (int i = 0; i < 3; ++i) {
                if (results[i] == null) continue;
                lastBlockEntity.setStack(i, results[i]);
            }
            RecipeUtil.putRemainders(remainingStacks, (Inventory)lastBlockEntity, lastWorld, lastBlockPos);
            world.syncWorldEvent(1035, pos, 0);
            callbackInfo.cancel();
        }
    }

    @Inject(method={"isValid"}, at={@At(value="HEAD")}, cancellable=true)
    public void isValidInvStack(int slotId, ItemStack stack, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (slotId < 4 && this.getStack(slotId).isEmpty() && stack.getItem() != Items.BLAZE_POWDER) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
    }
}

