/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.mixin.cauldron;

import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.recipe.cauldron.CauldronRecipe;
import de.siphalor.nbtcrafting3.recipe.cauldron.TemporaryCauldronInventory;
import java.util.Optional;
import net.minecraft.block.AbstractCauldronBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.collection.DefaultedList;
import net.minecraft.util.hit.BlockHitResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractCauldronBlock.class})
public class MixinCauldronBlock {
    @Inject(method={"onUse"}, at={@At(value="HEAD")}, cancellable=true)
    public void onActivate(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockHitResult blockHitResult, CallbackInfoReturnable<ActionResult> callbackInfoReturnable) {
        if (!world.isClient()) {
            TemporaryCauldronInventory inventory = new TemporaryCauldronInventory(playerEntity, hand, world, blockPos);
            Optional cauldronRecipe = world.getRecipeManager().getFirstMatch(NbtCrafting.CAULDRON_RECIPE_TYPE, (Inventory)inventory, world);
            if (cauldronRecipe.isPresent()) {
                ItemEntity itemEntity;
                DefaultedList remainingStacks = ((CauldronRecipe)cauldronRecipe.get()).getRemainder(inventory);
                ItemStack itemStack = ((CauldronRecipe)cauldronRecipe.get()).craft(inventory);
                itemStack.onCraft(world, playerEntity, itemStack.getCount());
                if (!playerEntity.getInventory().insertStack((ItemStack)remainingStacks.get(0)) && (itemEntity = playerEntity.dropItem((ItemStack)remainingStacks.get(0), false)) != null) {
                    itemEntity.resetPickupDelay();
                    itemEntity.setOwner(playerEntity.getUuid());
                }
                if (!playerEntity.getInventory().insertStack(itemStack) && (itemEntity = playerEntity.dropItem(itemStack, false)) != null) {
                    itemEntity.resetPickupDelay();
                    itemEntity.setOwner(playerEntity.getUuid());
                }
                callbackInfoReturnable.setReturnValue((Object)ActionResult.SUCCESS);
            }
        }
    }
}

