/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.mixin.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.api.JsonPreprocessor;
import de.siphalor.nbtcrafting3.api.RecipeUtil;
import de.siphalor.nbtcrafting3.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting3.util.duck.IItemStack;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.StringNbtReader;
import net.minecraft.recipe.Ingredient;
import net.minecraft.recipe.ShapedRecipe;
import net.minecraft.util.Identifier;
import net.minecraft.util.JsonHelper;
import net.minecraft.util.collection.DefaultedList;
import net.minecraft.util.registry.Registry;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ShapedRecipe.class})
public abstract class MixinShapedRecipe {
    @Shadow
    @Final
    private ItemStack output;
    @Shadow
    @Final
    private DefaultedList<Ingredient> input;

    @Inject(method={"outputFromJson"}, at={@At(value="HEAD")})
    private static void handlePotions(JsonObject json, CallbackInfoReturnable<ItemStack> ci) {
        if (!NbtCrafting.isAdvancedIngredientSerializationEnabled()) {
            return;
        }
        if (json.has("potion")) {
            JsonObject dataObject;
            Identifier identifier = new Identifier(JsonHelper.getString((JsonObject)json, (String)"potion"));
            if (!Registry.POTION.getOrEmpty(identifier).isPresent()) {
                throw new JsonParseException("The given resulting potion does not exist!");
            }
            if (!json.has("data")) {
                dataObject = new JsonObject();
                json.add("data", (JsonElement)dataObject);
            } else {
                dataObject = JsonHelper.getObject((JsonObject)json, (String)"data");
            }
            dataObject.addProperty("Potion", identifier.toString());
            json.addProperty("item", "minecraft:potion");
        }
    }

    @Inject(method={"outputFromJson"}, at={@At(value="INVOKE", target="com/google/gson/JsonObject.has(Ljava/lang/String;)Z", remap=false)})
    private static void deserializeItemStack(JsonObject json, CallbackInfoReturnable<ItemStack> ci) {
        if (!NbtCrafting.isAdvancedIngredientSerializationEnabled()) {
            return;
        }
        NbtCrafting.clearLastReadNbt();
        if (json.has("data")) {
            if (JsonHelper.hasString((JsonObject)json, (String)"data")) {
                try {
                    NbtCrafting.setLastReadNbt(new StringNbtReader(new StringReader(json.get("data").getAsString())).parseCompound());
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                NbtCrafting.setLastReadNbt((NbtCompound)NbtUtil.asTag(JsonPreprocessor.process((JsonElement)JsonHelper.getObject((JsonObject)json, (String)"data"))));
            }
            json.remove("data");
        }
    }

    @Inject(method={"outputFromJson"}, at={@At(value="RETURN")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void constructDeserializedItemStack(JsonObject json, CallbackInfoReturnable<ItemStack> ci, Item item, int amount) {
        if (!NbtCrafting.isAdvancedIngredientSerializationEnabled()) {
            return;
        }
        ItemStack stack = new ItemStack((ItemConvertible)item, amount);
        if (NbtCrafting.hasLastReadNbt()) {
            NbtCompound lastReadNbt = NbtCrafting.useLastReadNbt();
            ((IItemStack)stack).nbtCrafting$setRawTag(lastReadNbt);
        }
        ci.setReturnValue((Object)stack);
    }

    @Inject(method={"craft"}, at={@At(value="HEAD")}, cancellable=true)
    public void craft(CraftingInventory craftingInventory, CallbackInfoReturnable<ItemStack> callbackInfoReturnable) {
        ItemStack result = RecipeUtil.getDollarAppliedResult(this.output, this.input, (Inventory)craftingInventory);
        if (result != null) {
            callbackInfoReturnable.setReturnValue((Object)result);
        }
    }
}

