/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.mixin.network;

import de.siphalor.nbtcrafting3.NbtCrafting;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.ClientConnection;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerManager;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.util.Identifier;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerManager.class})
public class MixinPlayerManager {
    @Shadow
    @Final
    private MinecraftServer server;
    @Shadow
    @Final
    private List<ServerPlayerEntity> players;

    @Inject(method={"onPlayerConnect"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/packet/s2c/play/CustomPayloadS2CPacket;<init>(Lnet/minecraft/util/Identifier;Lnet/minecraft/network/PacketByteBuf;)V")})
    public void beforeRegistrySync(ClientConnection connection, ServerPlayerEntity player, CallbackInfo ci) {
        NbtCrafting.lastServerPlayerEntity.set(player);
    }

    @Inject(method={"onPlayerConnect"}, at={@At(value="RETURN")})
    public void afterRecipeSync(ClientConnection connection, ServerPlayerEntity player, CallbackInfo ci) {
        if (NbtCrafting.hasClientMod(player)) {
            NbtCrafting.logInfo("Syncing advanced recipe data to player " + player.getEntityName());
            List<PacketByteBuf> packets = NbtCrafting.createAdvancedRecipeSyncPackets(this.server.getRecipeManager());
            for (PacketByteBuf packet : packets) {
                ServerPlayNetworking.send((ServerPlayerEntity)player, (Identifier)NbtCrafting.UPDATE_ADVANCED_RECIPES_PACKET_ID, (PacketByteBuf)packet);
            }
        } else {
            NbtCrafting.logInfo("Skipping advanced recipe data synchronization for vanillish player " + player.getEntityName());
        }
    }

    @Inject(method={"onDataPacksReloaded"}, at={@At(value="RETURN")})
    public void onDataPacksReloaded(CallbackInfo ci) {
        List nbtcPlayers = this.players.stream().filter(NbtCrafting::hasClientMod).collect(Collectors.toList());
        if (!nbtcPlayers.isEmpty()) {
            NbtCrafting.logInfo("Syncing advanced recipe data to " + nbtcPlayers.size() + " players");
            List<PacketByteBuf> packets = NbtCrafting.createAdvancedRecipeSyncPackets(this.server.getRecipeManager());
            for (PacketByteBuf packet : packets) {
                for (ServerPlayerEntity player : nbtcPlayers) {
                    ServerPlayNetworking.send((ServerPlayerEntity)player, (Identifier)NbtCrafting.UPDATE_ADVANCED_RECIPES_PACKET_ID, (PacketByteBuf)packet);
                }
            }
        } else {
            NbtCrafting.logInfo("No advanced recipe data needs to be synced!");
        }
    }
}

