/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.mixin.smithing;

import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.api.RecipeUtil;
import de.siphalor.nbtcrafting3.recipe.IngredientRecipe;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.screen.ForgingScreenHandler;
import net.minecraft.screen.ScreenHandlerContext;
import net.minecraft.screen.ScreenHandlerType;
import net.minecraft.screen.SmithingScreenHandler;
import net.minecraft.util.collection.DefaultedList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SmithingScreenHandler.class})
public abstract class MixinSmithingScreenHandler
extends ForgingScreenHandler {
    @Unique
    private static DefaultedList<ItemStack> remainders = null;

    public MixinSmithingScreenHandler(ScreenHandlerType<?> type, int syncId, PlayerInventory playerInventory, ScreenHandlerContext context) {
        super(type, syncId, playerInventory, context);
    }

    @Inject(method={"updateResult"}, at={@At(value="HEAD")}, cancellable=true)
    public void onUpdateResult(CallbackInfo callbackInfo) {
        Optional match = this.player.world.getRecipeManager().getFirstMatch(NbtCrafting.SMITHING_RECIPE_TYPE, this.input, this.player.world);
        if (match.isPresent()) {
            this.output.setStack(0, ((IngredientRecipe)match.get()).craft(this.input));
            callbackInfo.cancel();
        }
    }

    @Inject(method={"canTakeOutput"}, at={@At(value="HEAD")}, cancellable=true)
    protected void canTakeOutput(PlayerEntity playerEntity, boolean stackPresent, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (stackPresent) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
    }

    @Inject(method={"onTakeOutput"}, at={@At(value="HEAD")})
    protected void onTakeOutput(PlayerEntity player, ItemStack stack, CallbackInfo ci) {
        Optional match = player.world.getRecipeManager().getFirstMatch(NbtCrafting.SMITHING_RECIPE_TYPE, this.input, player.world);
        remainders = match.map(inventoryIngredientRecipe -> inventoryIngredientRecipe.getRemainder(this.input)).orElse(null);
    }

    @Inject(method={"onTakeOutput"}, at={@At(value="TAIL")})
    protected void onOutputTaken(PlayerEntity player, ItemStack stack, CallbackInfo ci) {
        if (remainders != null) {
            this.context.run((world, blockPos) -> RecipeUtil.putRemainders(remainders, this.input, world, blockPos));
        }
    }
}

