/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.recipe;

import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.api.RecipeUtil;
import de.siphalor.nbtcrafting3.dollar.exception.UnresolvedDollarReferenceException;
import de.siphalor.nbtcrafting3.recipe.IngredientRecipe;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.recipe.Ingredient;
import net.minecraft.recipe.RecipeSerializer;
import net.minecraft.util.Identifier;
import net.minecraft.util.collection.DefaultedList;
import net.minecraft.world.World;

public class BrewingRecipe
extends IngredientRecipe<Inventory> {
    public static final RecipeSerializer<BrewingRecipe> SERIALIZER = new IngredientRecipe.Serializer<BrewingRecipe>(BrewingRecipe::new);

    public BrewingRecipe(Identifier identifier, Ingredient base, Ingredient ingredient, ItemStack result, IngredientRecipe.Serializer<BrewingRecipe> serializer) {
        super(identifier, base, ingredient, result, NbtCrafting.BREWING_RECIPE_TYPE, serializer);
    }

    @Override
    public boolean matches(Inventory inv, World world) {
        if (this.ingredient.test(inv.getStack(3))) {
            for (int i = 0; i < 3; ++i) {
                if (!this.base.test(inv.getStack(i))) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack[] craftAll(Inventory inv) {
        ItemStack[] stacks = new ItemStack[3];
        for (int i = 0; i < 3; ++i) {
            if (!this.base.test(inv.getStack(i))) continue;
            int finalI = i;
            stacks[i] = RecipeUtil.applyDollars(this.result.copy(), this.resultDollars, ref -> this.resolveReference(inv, finalI, ref));
        }
        return stacks;
    }

    public DefaultedList<ItemStack> getRemainder(Inventory inv) {
        DefaultedList stacks = DefaultedList.ofSize((int)4, (Object)ItemStack.EMPTY);
        stacks.set(3, (Object)RecipeUtil.getRemainder(inv.getStack(3), this.ingredient, ref -> {
            if ("ingredient".equals(ref)) {
                return inv.getStack(3);
            }
            throw new UnresolvedDollarReferenceException(ref);
        }));
        for (int i = 0; i < 3; ++i) {
            if (!this.base.test(inv.getStack(i))) continue;
            int finalI = i;
            stacks.set(i, (Object)RecipeUtil.getRemainder(inv.getStack(i), this.base, ref -> this.resolveReference(inv, finalI, ref)));
        }
        return stacks;
    }

    private Object resolveReference(Inventory inv, int baseIndex, String reference) throws UnresolvedDollarReferenceException {
        switch (reference) {
            case "ingredient": {
                return inv.getStack(3);
            }
            case "base": {
                return inv.getStack(baseIndex);
            }
        }
        throw new UnresolvedDollarReferenceException(reference);
    }
}

