/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.siphalor.nbtcrafting3.api.RecipeUtil;
import de.siphalor.nbtcrafting3.api.ServerRecipe;
import de.siphalor.nbtcrafting3.api.recipe.NBTCRecipe;
import de.siphalor.nbtcrafting3.dollar.Dollar;
import de.siphalor.nbtcrafting3.dollar.DollarExtractor;
import de.siphalor.nbtcrafting3.dollar.exception.UnresolvedDollarReferenceException;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.recipe.Ingredient;
import net.minecraft.recipe.RecipeSerializer;
import net.minecraft.recipe.RecipeType;
import net.minecraft.recipe.ShapedRecipe;
import net.minecraft.util.Identifier;
import net.minecraft.util.JsonHelper;
import net.minecraft.util.collection.DefaultedList;
import net.minecraft.world.World;

public class IngredientRecipe<I extends Inventory>
implements NBTCRecipe<I>,
ServerRecipe {
    private final Identifier identifier;
    protected final Ingredient base;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final Dollar[] resultDollars;
    protected final RecipeType<? extends IngredientRecipe<I>> recipeType;
    protected final RecipeSerializer<? extends IngredientRecipe<I>> serializer;

    public IngredientRecipe(Identifier identifier, Ingredient base, Ingredient ingredient, ItemStack result, RecipeType<? extends IngredientRecipe<I>> recipeType, RecipeSerializer<? extends IngredientRecipe<I>> serializer) {
        this.identifier = identifier;
        this.base = base;
        this.ingredient = ingredient;
        this.result = result;
        this.resultDollars = DollarExtractor.extractDollars(result.getTag(), true);
        this.recipeType = recipeType;
        this.serializer = serializer;
    }

    public boolean matches(I inv, World world) {
        if (this.ingredient != null && this.ingredient.test(inv.getStack(1))) {
            return this.base.test(inv.getStack(0));
        }
        return false;
    }

    public boolean fits(int width, int height) {
        return false;
    }

    public ItemStack craft(I inv) {
        return RecipeUtil.applyDollars(this.result.copy(), this.resultDollars, this.getReferenceResolver(inv));
    }

    public ItemStack getOutput() {
        return this.result;
    }

    public Identifier getId() {
        return this.identifier;
    }

    public Ingredient getBase() {
        return this.base;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public DefaultedList<Ingredient> getIngredients() {
        return DefaultedList.copyOf((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.base, this.ingredient});
    }

    public RecipeType<?> getType() {
        return this.recipeType;
    }

    public RecipeSerializer<? extends IngredientRecipe<I>> getSerializer() {
        return this.serializer;
    }

    @Override
    public ReferenceResolver getReferenceResolver(I inv) {
        return ref -> {
            switch (ref) {
                case "base": {
                    return inv.getStack(0);
                }
                case "ingredient": {
                    return inv.getStack(1);
                }
            }
            throw new UnresolvedDollarReferenceException(ref);
        };
    }

    public void readCustomData(JsonObject json) {
    }

    public void readCustomData(PacketByteBuf buf) {
    }

    public void writeCustomData(PacketByteBuf buf) {
    }

    public static class Serializer<R extends IngredientRecipe<?>>
    implements RecipeSerializer<R> {
        private final Factory<R> factory;

        public Serializer(Factory<R> factory) {
            this.factory = factory;
        }

        public R read(Identifier id, JsonObject json) {
            Ingredient base = Ingredient.fromJson((JsonElement)json.get("base"));
            Ingredient ingredient = json.has("ingredient") ? Ingredient.fromJson((JsonElement)json.get("ingredient")) : Ingredient.EMPTY;
            ItemStack result = ShapedRecipe.outputFromJson((JsonObject)JsonHelper.getObject((JsonObject)json, (String)"result"));
            R recipe = this.factory.create(id, base, ingredient, result, this);
            ((IngredientRecipe)recipe).readCustomData(json);
            return recipe;
        }

        public R read(Identifier id, PacketByteBuf buf) {
            Ingredient base = Ingredient.fromPacket((PacketByteBuf)buf);
            Ingredient ingredient = Ingredient.fromPacket((PacketByteBuf)buf);
            ItemStack result = buf.readItemStack();
            R recipe = this.factory.create(id, base, ingredient, result, this);
            ((IngredientRecipe)recipe).readCustomData(buf);
            return recipe;
        }

        public void write(PacketByteBuf buf, R recipe) {
            ((IngredientRecipe)recipe).base.write(buf);
            ((IngredientRecipe)recipe).ingredient.write(buf);
            buf.writeItemStack(((IngredientRecipe)recipe).result);
            ((IngredientRecipe)recipe).writeCustomData(buf);
        }
    }

    public static interface Factory<R extends IngredientRecipe<?>> {
        public R create(Identifier var1, Ingredient var2, Ingredient var3, ItemStack var4, Serializer<R> var5);
    }
}

