/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.recipe.cauldron;

import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.api.RecipeUtil;
import de.siphalor.nbtcrafting3.api.ServerRecipe;
import de.siphalor.nbtcrafting3.api.recipe.NBTCRecipe;
import de.siphalor.nbtcrafting3.dollar.Dollar;
import de.siphalor.nbtcrafting3.dollar.DollarExtractor;
import de.siphalor.nbtcrafting3.dollar.exception.UnresolvedDollarReferenceException;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;
import de.siphalor.nbtcrafting3.recipe.cauldron.TemporaryCauldronInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.recipe.Ingredient;
import net.minecraft.recipe.RecipeSerializer;
import net.minecraft.recipe.RecipeType;
import net.minecraft.util.Identifier;
import net.minecraft.util.collection.DefaultedList;
import net.minecraft.world.World;

public class CauldronRecipe
implements NBTCRecipe<TemporaryCauldronInventory>,
ServerRecipe {
    private final Identifier identifier;
    public final Ingredient input;
    public final ItemStack output;
    public final Identifier fluid;
    public final int levels;
    private final Dollar[] outputDollars;

    public CauldronRecipe(Identifier id, Ingredient ingredient, ItemStack output, Identifier fluid, int levels) {
        this.identifier = id;
        this.input = ingredient;
        this.output = output;
        this.fluid = fluid;
        this.levels = levels;
        this.outputDollars = DollarExtractor.extractDollars(output.getTag(), false);
    }

    public void write(PacketByteBuf packetByteBuf) {
        packetByteBuf.writeIdentifier(this.identifier);
        this.input.write(packetByteBuf);
        packetByteBuf.writeItemStack(this.output);
        packetByteBuf.writeIdentifier(this.fluid);
        packetByteBuf.writeShort(this.levels);
    }

    public static CauldronRecipe from(PacketByteBuf packetByteBuf) {
        Identifier identifier = packetByteBuf.readIdentifier();
        Ingredient input = Ingredient.fromPacket((PacketByteBuf)packetByteBuf);
        ItemStack output = packetByteBuf.readItemStack();
        Identifier fluid = packetByteBuf.readIdentifier();
        short levels = packetByteBuf.readShort();
        return new CauldronRecipe(identifier, input, output, fluid, levels);
    }

    public boolean matches(TemporaryCauldronInventory inventory, World world) {
        if (this.fluid != null && !this.fluid.equals((Object)inventory.getFluid())) {
            return false;
        }
        if (!this.input.test(inventory.getStack(0))) {
            return false;
        }
        if (this.levels >= 0) {
            return inventory.getLevel() >= this.levels;
        }
        return inventory.getMaxLevel() - inventory.getLevel() >= -this.levels;
    }

    public ItemStack craft(TemporaryCauldronInventory inventory) {
        int level = inventory.getLevel() - this.levels;
        ItemStack result = RecipeUtil.applyDollars(this.output.copy(), this.outputDollars, ref -> {
            switch (ref) {
                case "ingredient": {
                    return inventory.getStack(0);
                }
                case "oldLevel": {
                    return inventory.getLevel();
                }
                case "newLevel": {
                    return level;
                }
            }
            throw new UnresolvedDollarReferenceException(ref);
        });
        inventory.setLevel(level);
        inventory.getStack(0).decrement(1);
        return result;
    }

    public boolean fits(int i, int i1) {
        return false;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public DefaultedList<Ingredient> getIngredients() {
        return DefaultedList.copyOf((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.input});
    }

    public Identifier getId() {
        return this.identifier;
    }

    public RecipeSerializer<?> getSerializer() {
        return NbtCrafting.CAULDRON_RECIPE_SERIALIZER;
    }

    public RecipeType<?> getType() {
        return NbtCrafting.CAULDRON_RECIPE_TYPE;
    }

    @Override
    public ReferenceResolver getReferenceResolver(TemporaryCauldronInventory inv) {
        return ref -> {
            if ("ingredient".equals(ref)) {
                return inv.getStack(0);
            }
            throw new UnresolvedDollarReferenceException(ref);
        };
    }
}

