/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.recipe.cauldron;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeveledCauldronBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.state.property.Property;
import net.minecraft.util.Hand;
import net.minecraft.util.Identifier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TemporaryCauldronInventory
implements Inventory {
    public static final Identifier AIR = new Identifier("air");
    public static final Identifier WATER = new Identifier("water");
    public static final Identifier LAVA = new Identifier("lava");
    public static final Identifier POWDER_SNOW = new Identifier("powder_snow");
    private ItemStack stackInHand;
    private final PlayerEntity playerEntity;
    private final Hand hand;
    private final Identifier fluid;
    private int level;
    private final World world;
    private final BlockPos blockPos;

    public TemporaryCauldronInventory(PlayerEntity playerEntity, Hand hand, World world, BlockPos blockPos) {
        this.playerEntity = playerEntity;
        this.hand = hand;
        this.world = world;
        this.blockPos = blockPos;
        this.stackInHand = playerEntity.getStackInHand(hand);
        BlockState blockState = world.getBlockState(blockPos);
        if (blockState.getBlock() == Blocks.WATER_CAULDRON) {
            this.fluid = WATER;
            this.level = (Integer)blockState.get((Property)LeveledCauldronBlock.LEVEL);
        } else if (blockState.getBlock() == Blocks.POWDER_SNOW_CAULDRON) {
            this.fluid = POWDER_SNOW;
            this.level = (Integer)blockState.get((Property)LeveledCauldronBlock.LEVEL);
        } else if (blockState.getBlock() == Blocks.LAVA_CAULDRON) {
            this.fluid = LAVA;
            this.level = 3;
        } else if (blockState.getBlock() == Blocks.CAULDRON) {
            this.fluid = AIR;
            this.level = 0;
        } else {
            this.fluid = null;
            this.level = 0;
        }
    }

    public Identifier getFluid() {
        return this.fluid;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        if (level <= 0) {
            this.level = 0;
            this.world.setBlockState(this.blockPos, Blocks.CAULDRON.getDefaultState());
            return;
        }
        if (this.fluid == WATER || this.fluid == POWDER_SNOW) {
            if (this.level <= 0) {
                Block block = this.fluid == WATER ? Blocks.WATER_CAULDRON : Blocks.POWDER_SNOW_CAULDRON;
                this.world.setBlockState(this.blockPos, (BlockState)block.getDefaultState().with((Property)LeveledCauldronBlock.LEVEL, (Comparable)Integer.valueOf(Math.min(level, 3))));
            } else {
                this.world.setBlockState(this.blockPos, (BlockState)this.world.getBlockState(this.blockPos).with((Property)LeveledCauldronBlock.LEVEL, (Comparable)Integer.valueOf(Math.min(level, 3))));
            }
        } else if (this.fluid == LAVA && this.level <= 0) {
            this.world.setBlockState(this.blockPos, Blocks.LAVA_CAULDRON.getDefaultState());
        }
        this.level = level;
    }

    public int getMaxLevel() {
        return 3;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return this.stackInHand.isEmpty();
    }

    public ItemStack getStack(int var1) {
        return this.stackInHand;
    }

    public ItemStack removeStack(int var1, int var2) {
        return this.stackInHand.split(var2);
    }

    public ItemStack removeStack(int var1) {
        this.playerEntity.setStackInHand(this.hand, ItemStack.EMPTY);
        ItemStack result = this.stackInHand;
        this.stackInHand = ItemStack.EMPTY;
        return result;
    }

    public void setStack(int var1, ItemStack var2) {
        this.playerEntity.setStackInHand(this.hand, var2);
    }

    public void markDirty() {
        this.playerEntity.getInventory().markDirty();
    }

    public boolean canPlayerUse(PlayerEntity var1) {
        return this.playerEntity == var1;
    }

    public void clear() {
        this.removeStack(0);
    }
}

