/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting3.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.dollar.Dollar;
import de.siphalor.nbtcrafting3.dollar.DollarExtractor;
import de.siphalor.nbtcrafting3.dollar.exception.DollarException;
import de.siphalor.nbtcrafting3.dollar.exception.UnresolvedDollarReferenceException;
import de.siphalor.nbtcrafting3.dollar.reference.MapBackedReferenceResolver;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;
import de.siphalor.nbtcrafting3.ingredient.IIngredient;

public class RecipeUtil {
	@Deprecated
	public static class_1799 getDollarAppliedOutputStack(class_1799 baseOutput, class_2371<class_1856> ingredients, class_1263 inventory) {
		return getDollarAppliedResult(baseOutput, ingredients, inventory);
	}

	public static class_1799 getDollarAppliedResult(class_1799 baseOutput, class_2371<class_1856> ingredients, class_1263 inventory) {
		class_1799 stack = baseOutput.method_7972();
		Dollar[] dollars = DollarExtractor.extractDollars(stack.method_7969(), true);

		if (dollars.length > 0) {
			return applyDollars(stack, dollars, buildReferenceResolverFromResolvedIngredients(resolveIngredients(ingredients, inventory), inventory));
		}
		return stack;
	}

	public static ReferenceResolver buildReferenceResolverFromResolvedIngredients(int[] resolvedIngredientStacks, class_1263 inventory) {
		Map<String, Object> reference = new HashMap<>();
		for (int i = 0; i < resolvedIngredientStacks.length; i++) {
			int resolvedIngredientStack = resolvedIngredientStacks[i];
			if (resolvedIngredientStack != -1) {
				reference.put("i" + i, inventory.method_5438(resolvedIngredientStack));
			}
		}
		return new MapBackedReferenceResolver(reference);
	}

	public static int[] resolveIngredients(List<class_1856> ingredients, class_1263 inventory) {
		final int ingredientCount = ingredients.size();
		final int inventorySize = inventory.method_5439();
		int[] resolvedIngredientStacks = new int[ingredientCount];
		boolean[] stackMatchesToAnything = new boolean[inventorySize]; // whether a stack has been resolved already
		byte[] matches = new byte[ingredientCount * inventorySize]; // 0 = unchecked, 1 = match, -1 = no match

		boolean advancedMatchingRequired = false;

		// try greedy matching
		outer:
		for (int j = 0; j < ingredientCount; j++) {
			class_1856 ingredient = ingredients.get(j);
			int ingredientMatchesOffset = j * inventorySize;
			for (int i = 0; i < inventorySize; i++) {
				if (stackMatchesToAnything[i])
					continue;

				if (ingredient.method_8093(inventory.method_5438(i))) {
					resolvedIngredientStacks[j] = i;
					matches[ingredientMatchesOffset + i] = 1;
					stackMatchesToAnything[i] = true;
					continue outer;
				} else {
					matches[ingredientMatchesOffset + i] = -1;
				}
			}

			// ingredient could not be matched
			advancedMatchingRequired = true;
			break;
		}

		if (!advancedMatchingRequired) {
			return resolvedIngredientStacks;
		}

		// fill rest of the match matrix
		for (int j = 0; j < ingredientCount; j++) {
			class_1856 ingredient = ingredients.get(j);
			int ingredientMatchesOffset = j * inventorySize;
			for (int i = 0; i < inventorySize; i++) {
				if (matches[ingredientMatchesOffset + i] == 0) { // combination has not been checked yet
					if (ingredient.method_8093(inventory.method_5438(i))) {
						matches[ingredientMatchesOffset + i] = 1;
					} else {
						matches[ingredientMatchesOffset + i] = -1;
					}
				}
			}
		}

		// try a reverse brute force matching
		int currentIngredient = 0; // the ingredient currently being matched
		int[] ingredientStackIndices = new int[ingredientCount]; // the stack indices currently being matched for each ingredient
		boolean[] usedStacks = new boolean[inventorySize]; // whether stacks are used in the current matching
		ingredientStackIndices[0] = inventorySize; // for reverse matching

		outer:
		while (true) {
			final int ingredientMatchesOffset = currentIngredient * inventorySize;
			int ingredientStackIndex = ingredientStackIndices[currentIngredient]; // temp variable to avoid constant array access
			while (true) {
				ingredientStackIndex--;

				if (ingredientStackIndex < 0) { // no matching stacks found
					currentIngredient--; // continue matching with the previous ingredient
					if (currentIngredient < 0) { // if there is no previous ingredient, no matching is possible
						// this should technically never happen, as recipes are checked for validity before reference maps are built
						NbtCrafting.logWarn("Failed to build reference map dynamically for recipe! Please report this on the Nbt Crafting issue tracker!");
						break outer;
					}

					// mark stack as free again
					usedStacks[ingredientStackIndices[currentIngredient]] = false;
					continue outer;
				}
				if (usedStacks[ingredientStackIndex]) { // stack is already in use
					continue;
				}

				if (matches[ingredientMatchesOffset + ingredientStackIndex] == 1) { // stack matches to the ingredient
					// mark stack as matched
					ingredientStackIndices[currentIngredient] = ingredientStackIndex;
					usedStacks[ingredientStackIndex] = true;

					currentIngredient++; // continue with the next ingredient
					if (currentIngredient >= ingredientCount) { // all ingredients have been matched, we're done
						break outer;
					}
					ingredientStackIndices[currentIngredient] = inventorySize; // for reverse matching

					continue outer;
				}
			}
		}

		return ingredientStackIndices;
	}

	@Deprecated
	public static class_1799 getDollarAppliedOutputStack(class_1799 baseOutput, class_1856 ingredient, class_1263 inventory) {
		return getDollarAppliedResult(baseOutput, ingredient, inventory);
	}

	public static class_1799 getDollarAppliedResult(class_1799 baseOutput, class_1856 ingredient, class_1263 inventory) {
		return getDollarAppliedResult(baseOutput, ingredient, "this", inventory);
	}

	@Deprecated
	public static class_1799 getDollarAppliedOutputStack(class_1799 baseOutput, class_1856 ingredient, String referenceName, class_1263 inventory) {
		return getDollarAppliedResult(baseOutput, ingredient, referenceName, inventory);
	}

	public static class_1799 getDollarAppliedResult(class_1799 baseOutput, class_1856 ingredient, String referenceName, class_1263 inventory) {
		class_1799 stack = baseOutput.method_7972();
		Dollar[] dollars = DollarExtractor.extractDollars(stack.method_7969(), true);

		if (dollars.length > 0) {
			return applyDollars(stack, dollars, ref -> {
				if (ref.equals(referenceName)) {
					return inventory.method_5438(0);
				}
				throw new UnresolvedDollarReferenceException(ref);
			});
		}
		return stack;
	}

	public static class_1799 getRemainder(class_1799 itemStack, class_1856 ingredient, ReferenceResolver referenceResolver) {
		class_1799 result = ((IIngredient) (Object) ingredient).nbtCrafting3$getRecipeRemainder(itemStack, referenceResolver);
		if (result == null) {
			return new class_1799(itemStack.method_7909().method_7858());
		}
		return result;
	}

	public static void putRemainders(class_2371<class_1799> remainders, class_1263 target, class_1937 world, class_2338 scatterPos) {
		putRemainders(remainders, target, world, scatterPos, 0);
	}

	public static void putRemainders(class_2371<class_1799> remainders, class_1263 target, class_1937 world, class_2338 scatterPos, int offset) {
		final int size = remainders.size();
		if (size > target.method_5439()) {
			throw new IllegalArgumentException("Size of given remainder list must be <= size of target inventory");
		}
		for (int i = 0; i < size; i++) {
			if (target.method_5438(offset + i).method_7960()) {
				target.method_5447(offset + i, remainders.get(i));
				remainders.set(i, class_1799.field_8037);
			}
		}
		class_1264.method_17349(world, scatterPos, remainders);
	}

	public static class_1799 applyDollars(class_1799 stack, Dollar[] dollars, ReferenceResolver referenceResolver) {
		for (Dollar dollar : dollars) {
			try {
				dollar.apply(stack, referenceResolver);
			} catch (DollarException e) {
				e.printStackTrace();
			}
		}
		if (stack.method_7919() > stack.method_7936()) {
			return class_1799.field_8037;
		}
		return stack;
	}
}
