/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting3.api.nbt;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

@FunctionalInterface
public interface NbtIterator {
	Action process(String path, String key, class_2520 tag);

	static void iterateTags(class_2520 tag, NbtIterator nbtIterator) {
		iterateTags(tag, nbtIterator, "");
	}

	static void iterateTags(class_2520 tag, NbtIterator nbtIterator, String path) {
		if (tag == null) return;
		if (tag instanceof class_2487) {
			class_2487 compoundTag = (class_2487) tag;
			if (!path.equals(""))
				path += ".";
			Set<String> remove = new HashSet<>();
			for (String key : compoundTag.method_10541()) {
				class_2520 currentTag = compoundTag.method_10580(key);
				switch (nbtIterator.process(path, key, currentTag)) {
					case REMOVE:
						remove.add(key);
						break;
					case RECURSE:
						iterateTags(currentTag, nbtIterator, path + key);
						break;
					case SKIP:
						break;
				}
			}
			for (String key : remove) {
				compoundTag.method_10551(key);
			}
		} else if (tag instanceof class_2483) {
			//noinspection unchecked
			class_2483<class_2520> listTag = (class_2483<class_2520>) tag;
			int i = 0;
			for (Iterator<class_2520> iterator = listTag.iterator(); iterator.hasNext(); ) {
				class_2520 currentTag = iterator.next();
				switch (nbtIterator.process(path, "[" + i + "]", currentTag)) {
					case REMOVE:
						iterator.remove();
						break;
					case RECURSE:
						iterateTags(currentTag, nbtIterator, path + "[" + i + "]");
						break;
					case SKIP:
						break;
				}
			}
		}
	}

	enum Action {
		RECURSE, SKIP, REMOVE
	}
}
