/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting3.dollar.part.special;

import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;

public class DollarStatementList implements DollarPart {
	private final DollarPart[] statements;

	private DollarStatementList(DollarPart[] statements) {
		this.statements = statements;
	}

	public static DollarPart of(DollarPart... statements) {
		if (statements.length == 1) {
			return statements[0];
		}
		return new DollarStatementList(statements);
	}

	@Override
	public Object evaluate(ReferenceResolver referenceResolver) throws DollarEvaluationException {
		Object result = null;
		for (DollarPart statement : statements) {
			result = statement.evaluate(referenceResolver);
		}
		return result;
	}
}
