/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting3.ingredient;

import java.util.Collection;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import com.google.gson.JsonElement;
import de.siphalor.nbtcrafting3.api.RecipeUtil;
import de.siphalor.nbtcrafting3.dollar.Dollar;
import de.siphalor.nbtcrafting3.dollar.DollarExtractor;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;

public abstract class IngredientEntry {
	protected class_1799 remainder;
	protected Dollar[] remainderDollars;

	public IngredientEntry() {
		this.remainder = null;
		this.remainderDollars = new Dollar[0];
	}

	public abstract boolean matches(class_1799 stack);

	public abstract JsonElement toJson();

	public Collection<class_1799> getPreviewStacks() {
		return getPreviewStacks(true);
	}

	public abstract Collection<class_1799> getPreviewStacks(boolean nbt);

	public abstract void write(class_2540 buf);

	public class_1799 getRecipeRemainder(class_1799 stack, ReferenceResolver referenceResolver) {
		if (remainder == null)
			return class_1799.field_8037;
		return RecipeUtil.applyDollars(remainder.method_7972(), remainderDollars, referenceResolver);
	}

	public void setRecipeRemainder(class_1799 stack) {
		this.remainder = stack;
		if (stack.method_7985())
			this.remainderDollars = DollarExtractor.extractDollars(stack.method_7969(), true);
	}
}
