/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting3.mixin;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

import de.siphalor.nbtcrafting3.api.RecipeUtil;
import de.siphalor.nbtcrafting3.api.recipe.NBTCRecipe;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;
import de.siphalor.nbtcrafting3.ingredient.IIngredient;

@Mixin(class_1860.class)
public interface MixinRecipe {
	@Shadow
	class_2371<class_1856> getIngredients();

	/**
	 * @reason Returns the recipe remainders. Sadly has to overwrite since this is an interface.
	 * @author Siphalor
	 */
	@Overwrite
	default class_2371<class_1799> getRemainder(class_1263 inventory) {
		final class_2371<class_1799> stackList = class_2371.method_10213(inventory.method_5439(), class_1799.field_8037);
		ReferenceResolver referenceResolver;
		List<class_1856> ingredients;
		int[] resolvedIngredientStacks;
		if (this instanceof NBTCRecipe) {
			ingredients = new ArrayList<>(((NBTCRecipe<?>) this).method_8117());
			// noinspection unchecked
			referenceResolver = ((NBTCRecipe<class_1263>) this).getReferenceResolver(inventory);
			resolvedIngredientStacks = RecipeUtil.resolveIngredients(ingredients, inventory);
		} else {
			ingredients = getIngredients();
			resolvedIngredientStacks = RecipeUtil.resolveIngredients(ingredients, inventory);
			referenceResolver = RecipeUtil.buildReferenceResolverFromResolvedIngredients(resolvedIngredientStacks, inventory);
		}

		for (int i = 0; i < stackList.size(); ++i) {
			class_1799 stack = inventory.method_5438(i);
			int ingredientIndex = ArrayUtils.indexOf(resolvedIngredientStacks, i);
			if (ingredientIndex >= 0) {
				class_1799 remainder = ((IIngredient) (Object) ingredients.get(ingredientIndex)).nbtCrafting3$getRecipeRemainder(stack, referenceResolver);
				if (remainder != null) {
					stackList.set(i, remainder);
					continue;
				}
			}
			if (stack.method_7909().method_7857()) {
				stackList.set(i, new class_1799(stack.method_7909().method_7858()));
			}
		}
		return stackList;
	}
}
