/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting3.mixin.anvil;
import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2585;
import net.minecraft.class_2653;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import net.minecraft.screen.*;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.recipe.AnvilRecipe;

@Mixin(class_1706.class)
public abstract class MixinAnvilContainer extends class_4861 {
	@Shadow
	private String newItemName;

	@Shadow
	@Final
	private class_3915 levelCost;

	@Shadow
	private int repairItemUsage;

	@Unique
	private boolean userChangedName = false;

	@Unique
	private class_1799 originalBaseStack;

	@Unique
	private AnvilRecipe recipe = null;

	public MixinAnvilContainer(@Nullable class_3917<?> type, int syncId, class_1661 playerInventory, class_3914 context) {
		super(type, syncId, playerInventory, context);
	}

	@Inject(method = "updateResult", at = @At("HEAD"), cancellable = true)
	public void updateResult(CallbackInfo callbackInfo) {
		recipe = field_22482.field_6002.method_8433().method_8132(NbtCrafting.ANVIL_RECIPE_TYPE, field_22480, field_22482.field_6002).orElse(null);
		if (recipe != null) {
			class_1799 resultStack = recipe.method_8116(field_22480);
			repairItemUsage = 1;
			if (userChangedName) {
				if (
						!StringUtils.isBlank(newItemName) &&
								!newItemName.equals(resultStack.method_7964().getString())
				) {
					resultStack.method_7977(new class_2585(newItemName));
				}
				userChangedName = false;
			} else {
				newItemName = resultStack.method_7964().getString();
				if (field_22482 instanceof class_3222) {
					if (NbtCrafting.hasClientMod((class_3222) field_22482)) {
						class_2540 packetByteBuf = new class_2540(Unpooled.buffer());
						packetByteBuf.method_10814(newItemName);
						ServerPlayNetworking.send((class_3222) field_22482, NbtCrafting.UPDATE_ANVIL_TEXT_S2C_PACKET_ID, packetByteBuf);
					}
				}
			}

			field_22479.method_5447(0, resultStack);

			levelCost.method_17404(recipe.getLevels());
			method_7623();

			callbackInfo.cancel();
		}
	}

	@Inject(method = "setNewItemName", at = @At("HEAD"))
	public void onNewItemNameSet(String newNewItemName, CallbackInfo callbackInfo) {
		userChangedName = true;
	}

	@Inject(
			method = "canTakeOutput",
			at = @At("HEAD"),
			cancellable = true
	)
	public void canTakeItemsTop(class_1657 player, boolean present, CallbackInfoReturnable<Boolean> cir) {
		if (levelCost.method_17407() <= 0) {
			class_1799 base = method_7611(0).method_7677();
			if (!class_1799.method_7987(method_7611(2).method_7677(), base) || !class_1799.method_7975(method_7611(2).method_7677(), base)) {
				cir.setReturnValue(true);
			}
		}
	}

	@Inject(
			method = "onTakeOutput",
			at = @At("HEAD")
	)
	public void onTakeItemTop(class_1657 player, class_1799 stack, CallbackInfo ci) {
		originalBaseStack = method_7611(0).method_7677();
	}

	@Inject(
			method = "onTakeOutput",
			at = @At("RETURN")
	)
	public void onItemTaken(class_1657 player, class_1799 stack, CallbackInfo ci) {
		if (recipe != null && originalBaseStack != null) {
			if (!recipe.getBase().method_8103()) {
				originalBaseStack.method_7934(1);
				method_7611(0).method_7673(originalBaseStack);
				stack.method_7982(player.field_6002, player, stack.method_7947());
			}
		}
		if (player instanceof class_3222) {
			if (!NbtCrafting.hasClientMod((class_3222) player)) {
				((class_3222) player).field_13987.method_14364(new class_2653(
						-1, method_37422(), 0, stack
				));
			}
		}
	}
}
