/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting3.mixin.cooking;

import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import net.minecraft.class_2609;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(class_2609.class)
public class MixinAbstractFurnaceBlockEntity {
	@Inject(
			method = "canAcceptRecipeOutput",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/item/ItemStack;getCount()I",
					ordinal = 0
			),
			locals = LocalCapture.CAPTURE_FAILHARD,
			cancellable = true
	)
	private static void canAcceptRecipeOutputNBTCheck(@Nullable class_1860<?> recipe, class_2371<class_1799> slots, int count, CallbackInfoReturnable<Boolean> cir, class_1799 recipeResult, class_1799 outputStack) {
		if (!class_1799.method_7975(recipeResult, outputStack)) {
			cir.setReturnValue(false);
		}
	}
}
