/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting3.recipe;

import com.google.gson.JsonObject;
import de.siphalor.nbtcrafting3.NbtCrafting;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class AnvilRecipe extends IngredientRecipe<class_1263> {
	protected int levels = 0;

	public static final IngredientRecipe.Serializer<AnvilRecipe> SERIALIZER = new IngredientRecipe.Serializer<>(AnvilRecipe::new);

	public AnvilRecipe(class_2960 identifier, class_1856 base, class_1856 ingredient, class_1799 result, Serializer<AnvilRecipe> serializer) {
		super(identifier, base, ingredient, result, NbtCrafting.ANVIL_RECIPE_TYPE, SERIALIZER);
	}

	public int getLevels() {
		return levels;
	}

	@Override
	public void readCustomData(JsonObject json) {
		super.readCustomData(json);
		levels = class_3518.method_15282(json, "levels", 0);
	}

	@Override
	public void readCustomData(class_2540 buf) {
		super.readCustomData(buf);
		levels = buf.method_10816();
	}

	@Override
	public void writeCustomData(class_2540 buf) {
		super.writeCustomData(buf);
		buf.method_10804(levels);
	}
}
