/*
 * Copyright 2020-2022 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nbtcrafting3.recipe;

import com.google.gson.JsonObject;
import de.siphalor.nbtcrafting3.api.RecipeUtil;
import de.siphalor.nbtcrafting3.api.ServerRecipe;
import de.siphalor.nbtcrafting3.api.recipe.NBTCRecipe;
import de.siphalor.nbtcrafting3.dollar.Dollar;
import de.siphalor.nbtcrafting3.dollar.DollarExtractor;
import de.siphalor.nbtcrafting3.dollar.exception.UnresolvedDollarReferenceException;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;

public class IngredientRecipe<I extends class_1263> implements NBTCRecipe<I>, ServerRecipe {
	private final class_2960 identifier;
	protected final class_1856 base;
	protected final class_1856 ingredient;
	protected final class_1799 result;
	protected final Dollar[] resultDollars;
	protected final class_3956<? extends IngredientRecipe<I>> recipeType;
	protected final class_1865<? extends IngredientRecipe<I>> serializer;

	public IngredientRecipe(class_2960 identifier, class_1856 base, class_1856 ingredient, class_1799 result, class_3956<? extends IngredientRecipe<I>> recipeType, class_1865<? extends IngredientRecipe<I>> serializer) {
		this.identifier = identifier;
		this.base = base;
		this.ingredient = ingredient;
		this.result = result;
		this.resultDollars = DollarExtractor.extractDollars(result.method_7969(), true);
		this.recipeType = recipeType;
		this.serializer = serializer;
	}

	@Override
	public boolean method_8115(I inv, class_1937 world) {
		if (ingredient != null && ingredient.method_8093(inv.method_5438(1))) {
			return base.method_8093(inv.method_5438(0));
		}
		return false;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return false;
	}

	@Override
	public class_1799 method_8116(I inv) {
		return RecipeUtil.applyDollars(result.method_7972(), resultDollars, getReferenceResolver(inv));
	}

	@Override
	public class_1799 method_8110() {
		return result;
	}

	@Override
	public class_2960 method_8114() {
		return identifier;
	}

	public class_1856 getBase() {
		return base;
	}

	public class_1856 getIngredient() {
		return ingredient;
	}

	@Override
	public class_2371<class_1856> method_8117() {
		return class_2371.method_10212(class_1856.field_9017, base, ingredient);
	}

	public class_3956<?> method_17716() {
		return recipeType;
	}

	@Override
	public class_1865<? extends IngredientRecipe<I>> method_8119() {
		return serializer;
	}

	@Override
	public ReferenceResolver getReferenceResolver(I inv) {
		return ref -> {
			switch (ref) {
				case "base":
					return inv.method_5438(0);
				case "ingredient":
					return inv.method_5438(1);
				default:
					throw new UnresolvedDollarReferenceException(ref);
			}
		};
	}

	public void readCustomData(JsonObject json) {
	}

	public void readCustomData(class_2540 buf) {
	}

	public void writeCustomData(class_2540 buf) {
	}

	public interface Factory<R extends IngredientRecipe<?>> {
		R create(class_2960 id, class_1856 base, class_1856 ingredient, class_1799 result, Serializer<R> serializer);
	}

	public static class Serializer<R extends IngredientRecipe<?>> implements class_1865<R> {
		private final Factory<R> factory;

		public Serializer(Factory<R> factory) {
			this.factory = factory;
		}

		@Override
		public R method_8121(class_2960 id, JsonObject json) {
			class_1856 base = class_1856.method_8102(json.get("base"));
			class_1856 ingredient;
			if (json.has("ingredient")) {
				ingredient = class_1856.method_8102(json.get("ingredient"));
			} else {
				ingredient = class_1856.field_9017;
			}
			class_1799 result = class_1869.method_35228(class_3518.method_15296(json, "result"));
			R recipe = factory.create(id, base, ingredient, result, this);
			recipe.readCustomData(json);
			return recipe;
		}

		@Override
		public R method_8122(class_2960 id, class_2540 buf) {
			class_1856 base = class_1856.method_8086(buf);
			class_1856 ingredient = class_1856.method_8086(buf);
			class_1799 result = buf.method_10819();
			R recipe = factory.create(id, base, ingredient, result, this);
			recipe.readCustomData(buf);
			return recipe;
		}

		@Override
		public void write(class_2540 buf, R recipe) {
			recipe.base.method_8088(buf);
			recipe.ingredient.method_8088(buf);
			buf.method_10793(recipe.result);
			recipe.writeCustomData(buf);
		}
	}
}
