/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.util.Pair;
import de.siphalor.nbtcrafting3.advancement.StatChangedCriterion;
import de.siphalor.nbtcrafting3.api.RecipeTypeHelper;
import de.siphalor.nbtcrafting3.ingredient.IIngredient;
import de.siphalor.nbtcrafting3.mixin.advancement.MixinCriterions;
import de.siphalor.nbtcrafting3.recipe.AnvilRecipe;
import de.siphalor.nbtcrafting3.recipe.BrewingRecipe;
import de.siphalor.nbtcrafting3.recipe.IngredientRecipe;
import de.siphalor.nbtcrafting3.recipe.WrappedRecipeSerializer;
import de.siphalor.nbtcrafting3.recipe.cauldron.CauldronRecipe;
import de.siphalor.nbtcrafting3.recipe.cauldron.CauldronRecipeSerializer;
import de.siphalor.nbtcrafting3.util.duck.IServerPlayerEntity;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1263;
import net.minecraft.class_1662;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class NbtCrafting
implements ModInitializer {
    public static final String MOD_ID = "nbtcrafting3";
    public static final String MOD_NAME = "Nbt Crafting v3";
    private static final String LOG_PREFIX = "[Nbt Crafting v3] ";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final class_2960 PRESENCE_CHANNEL = new class_2960("nbtcrafting3", "present");
    public static final class_2960 UPDATE_ANVIL_TEXT_S2C_PACKET_ID = new class_2960("nbtcrafting3", "update_anvil_text");
    public static final class_2960 UPDATE_ADVANCED_RECIPES_PACKET_ID = new class_2960("nbtcrafting3", "update_advanced_recipes");
    public static final class_3956<AnvilRecipe> ANVIL_RECIPE_TYPE = NbtCrafting.registerRecipeType("anvil");
    public static final class_1865<AnvilRecipe> ANVIL_RECIPE_SERIALIZER = NbtCrafting.registerRecipeSerializer("anvil", AnvilRecipe.SERIALIZER);
    public static final class_3956<BrewingRecipe> BREWING_RECIPE_TYPE = NbtCrafting.registerRecipeType("brewing");
    public static final class_1865<BrewingRecipe> BREWING_RECIPE_SERIALIZER = NbtCrafting.registerRecipeSerializer("brewing", BrewingRecipe.SERIALIZER);
    public static final class_3956<CauldronRecipe> CAULDRON_RECIPE_TYPE = NbtCrafting.registerRecipeType("cauldron");
    public static final CauldronRecipeSerializer CAULDRON_RECIPE_SERIALIZER = NbtCrafting.registerRecipeSerializer("cauldron", new CauldronRecipeSerializer());
    public static final class_3956<IngredientRecipe<class_1263>> SMITHING_RECIPE_TYPE = NbtCrafting.registerRecipeType("smithing");
    public static final class_1865<IngredientRecipe<class_1263>> SMITHING_RECIPE_SERIALIZER = NbtCrafting.registerRecipeSerializer("smithing", new IngredientRecipe.Serializer<IngredientRecipe>((id, base, ingredient, result, serializer) -> new IngredientRecipe<class_1263>(id, base, ingredient, result, SMITHING_RECIPE_TYPE, serializer)));
    public static final class_1865<class_1860<?>> DATA_RECIPE_SERIALIZER = NbtCrafting.registerRecipeSerializer("data", new WrappedRecipeSerializer());
    public static final StatChangedCriterion STAT_CHANGED_CRITERION = MixinCriterions.registerCriterion(new StatChangedCriterion());
    private static boolean lastReadNbtPresent = false;
    private static class_2487 lastReadNbt;
    public static class_1662 lastRecipeFinder;
    public static ThreadLocal<class_3222> lastServerPlayerEntity;
    public static ThreadLocal<Boolean> advancedIngredientSerializationEnabled;
    private static final IntSet hasModClientConnectionHashes;
    private static int currentStackId;
    public static final Int2ObjectMap<Pair<Integer, class_2487>> id2StackMap;
    public static final LoadingCache<Pair<Integer, class_2487>, Integer> stack2IdMap;

    public static void logInfo(String message) {
        LOGGER.info(LOG_PREFIX + message);
    }

    public static void logWarn(String message) {
        LOGGER.warn(LOG_PREFIX + message);
    }

    public static void logError(String message) {
        LOGGER.error(LOG_PREFIX + message);
    }

    public static boolean hasLastReadNbt() {
        return lastReadNbtPresent;
    }

    public static void clearLastReadNbt() {
        lastReadNbt = null;
        lastReadNbtPresent = false;
    }

    public static void setLastReadNbt(class_2487 nbt) {
        lastReadNbt = nbt;
        lastReadNbtPresent = true;
    }

    public static class_2487 useLastReadNbt() {
        class_2487 result = null;
        if (lastReadNbt != null) {
            result = lastReadNbt.method_10553();
            lastReadNbt = null;
        }
        lastReadNbtPresent = false;
        return result;
    }

    public void onInitialize() {
        ServerLoginConnectionEvents.QUERY_START.register((handler, server, sender, synchronizer) -> sender.sendPacket(PRESENCE_CHANNEL, new class_2540(Unpooled.buffer())));
        ServerLoginConnectionEvents.DISCONNECT.register((handler, server) -> hasModClientConnectionHashes.remove(handler.method_2872().hashCode()));
        ServerLoginNetworking.registerGlobalReceiver((class_2960)PRESENCE_CHANNEL, (server, handler, understood, buf, synchronizer, responseSender) -> {
            if (understood) {
                hasModClientConnectionHashes.add(handler.method_2872().hashCode());
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (hasModClientConnectionHashes.contains(handler.method_2872().hashCode())) {
                ((IServerPlayerEntity)handler.field_14140).nbtCrafting3$setClientModPresent(true);
                hasModClientConnectionHashes.remove(handler.method_2872().hashCode());
            }
        });
    }

    public static boolean hasClientMod(class_3222 playerEntity) {
        if (playerEntity instanceof IServerPlayerEntity) {
            return ((IServerPlayerEntity)playerEntity).nbtCrafting3$hasClientMod();
        }
        return false;
    }

    public static <T extends class_1860<?>> class_3956<T> registerRecipeType(final String name) {
        class_2960 recipeTypeId = new class_2960(MOD_ID, name);
        RecipeTypeHelper.addToSyncBlacklist(recipeTypeId);
        return (class_3956)class_2378.method_10230((class_2378)class_2378.field_17597, (class_2960)recipeTypeId, (Object)new class_3956<T>(){

            public String toString() {
                return "nbtcrafting3:" + name;
            }
        });
    }

    public static <S extends class_1865<T>, T extends class_1860<?>> S registerRecipeSerializer(String name, S recipeSerializer) {
        class_2960 serializerId = new class_2960(MOD_ID, name);
        RecipeTypeHelper.addToSyncBlacklist(serializerId);
        return (S)((class_1865)class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)serializerId, recipeSerializer));
    }

    public static List<class_2540> createAdvancedRecipeSyncPackets(class_1863 recipeManager) {
        advancedIngredientSerializationEnabled.set(true);
        List recipes = recipeManager.method_8126().stream().filter(recipe -> {
            for (class_1856 ingredient : recipe.method_8117()) {
                if (!((IIngredient)ingredient).nbtCrafting3$isAdvanced()) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        ArrayList<class_2540> packets = new ArrayList<class_2540>();
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10804(0);
        for (class_1860 recipe2 : recipes) {
            class_1865 serializer = recipe2.method_8119();
            buf.method_10812(class_2378.field_17598.method_10221((Object)serializer));
            buf.method_10812(recipe2.method_8114());
            serializer.method_8124(buf, recipe2);
            if (buf.readableBytes() <= 1900000) continue;
            packets.add(buf);
            buf = new class_2540(Unpooled.buffer());
            buf.method_10804(0);
        }
        advancedIngredientSerializationEnabled.set(false);
        return packets;
    }

    public static boolean isAdvancedIngredientSerializationEnabled() {
        return advancedIngredientSerializationEnabled.get() != null && advancedIngredientSerializationEnabled.get() != false;
    }

    static {
        lastServerPlayerEntity = new ThreadLocal();
        advancedIngredientSerializationEnabled = new ThreadLocal();
        hasModClientConnectionHashes = IntSets.synchronize((IntSet)new IntAVLTreeSet());
        currentStackId = 1;
        id2StackMap = new Int2ObjectAVLTreeMap();
        stack2IdMap = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener(notification -> {
            Int2ObjectMap<Pair<Integer, class_2487>> int2ObjectMap = id2StackMap;
            synchronized (int2ObjectMap) {
                id2StackMap.remove(((Integer)notification.getValue()).intValue());
            }
        }).build((CacheLoader)new CacheLoader<Pair<Integer, class_2487>, Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer load(@NotNull Pair<Integer, class_2487> key) {
                Int2ObjectMap<Pair<Integer, class_2487>> int2ObjectMap = id2StackMap;
                synchronized (int2ObjectMap) {
                    while (id2StackMap.putIfAbsent(currentStackId, key) != null) {
                        ++currentStackId;
                    }
                    int n = currentStackId++;
                    return n;
                }
            }
        });
    }
}

