/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.api.nbt;

import net.minecraft.class_2489;
import net.minecraft.class_2497;
import net.minecraft.class_2514;

public class NbtNumberRange {
    public static final NbtNumberRange ANY_INT = new NbtNumberRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, true);
    public static final NbtNumberRange ANY_DOUBLE = new NbtNumberRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, false);
    public final double begin;
    public final double end;
    private final boolean isInteger;

    private NbtNumberRange(double begin, double end, boolean isInteger) {
        this.begin = begin;
        this.end = end;
        this.isInteger = isInteger;
    }

    public boolean matches(double c) {
        return c >= this.begin && c <= this.end;
    }

    public class_2514 getExample() {
        if (Double.isFinite(this.begin)) {
            if (Double.isFinite(this.end)) {
                return this.isInteger ? class_2497.method_23247((int)((int)Math.round((this.begin + this.end) / 2.0))) : class_2489.method_23241((double)((this.begin + this.end) / 2.0));
            }
            return this.isInteger ? class_2497.method_23247((int)((int)Math.round(this.begin))) : class_2489.method_23241((double)this.begin);
        }
        if (Double.isFinite(this.end)) {
            return this.isInteger ? class_2497.method_23247((int)((int)Math.round(this.end))) : class_2489.method_23241((double)this.end);
        }
        return this.isInteger ? class_2497.method_23247((int)0) : class_2489.method_23241((double)0.0);
    }

    public static NbtNumberRange equals(Number a) {
        return new NbtNumberRange(a.doubleValue(), a.doubleValue(), NbtNumberRange.isInteger(a));
    }

    public static NbtNumberRange between(Number a, Number b) {
        return new NbtNumberRange(Math.min(a.doubleValue(), b.doubleValue()), Math.max(a.doubleValue(), b.doubleValue()), NbtNumberRange.isInteger(a) && NbtNumberRange.isInteger(b));
    }

    public static NbtNumberRange fromInfinity(Number end) {
        return new NbtNumberRange(Double.NEGATIVE_INFINITY, end.doubleValue(), NbtNumberRange.isInteger(end));
    }

    public static NbtNumberRange toInfinity(Number begin) {
        return new NbtNumberRange(begin.doubleValue(), Double.POSITIVE_INFINITY, NbtNumberRange.isInteger(begin));
    }

    public static NbtNumberRange ofString(String string) {
        int position;
        if (!string.contains("..")) {
            try {
                return NbtNumberRange.equals(NbtNumberRange.parseNumber(string));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if ((position = string.indexOf("..")) == 0) {
            try {
                return NbtNumberRange.fromInfinity(NbtNumberRange.parseNumber(string.substring(2)));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        } else if (position == string.length() - 2) {
            try {
                return NbtNumberRange.toInfinity(NbtNumberRange.parseNumber(string.substring(0, string.length() - 2)));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        } else {
            try {
                return NbtNumberRange.between(NbtNumberRange.parseNumber(string.substring(0, position)), NbtNumberRange.parseNumber(string.substring(position + 2)));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return ANY_INT;
    }

    private static Number parseNumber(String string) throws NumberFormatException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return Double.parseDouble(string);
        }
    }

    private static boolean isInteger(Number number) {
        return number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long;
    }
}

