/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar.part.binary;

import de.siphalor.nbtcrafting3.dollar.exception.DollarDeserializationException;
import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ConstantDollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ValueDollarPart;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;

public abstract class BinaryDollarOperator
implements DollarPart {
    protected final DollarPart first;
    protected final DollarPart second;

    public BinaryDollarOperator(DollarPart first, DollarPart second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public Object evaluate(ReferenceResolver referenceResolver) throws DollarEvaluationException {
        return this.apply(this.first.evaluate(referenceResolver), this.second.evaluate(referenceResolver));
    }

    public abstract Object apply(Object var1, Object var2) throws DollarEvaluationException;

    protected static DollarPart shortCircuitConstant(BinaryDollarOperator operator) throws DollarDeserializationException {
        if (operator.first instanceof ConstantDollarPart && operator.second instanceof ConstantDollarPart) {
            try {
                return ValueDollarPart.of(operator.apply(((ConstantDollarPart)operator.first).getConstantValue(), ((ConstantDollarPart)operator.second).getConstantValue()));
            }
            catch (DollarEvaluationException e) {
                throw new DollarDeserializationException("Failed to short-circuit dollar operator " + operator.getClass().getSimpleName(), e);
            }
        }
        return operator;
    }
}

