/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar.part.binary;

import de.siphalor.nbtcrafting3.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting3.dollar.DollarUtil;
import de.siphalor.nbtcrafting3.dollar.exception.DollarDeserializationException;
import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.part.DollarBinding;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.part.binary.BinaryDollarOperator;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;

public class ChildDollarOperator
extends BinaryDollarOperator
implements DollarBinding {
    private final boolean propagateEmpty;

    public ChildDollarOperator(DollarPart first, DollarPart second) {
        this(first, second, false);
    }

    public ChildDollarOperator(DollarPart first, DollarPart second, boolean propagateEmpty) {
        super(first, second);
        this.propagateEmpty = propagateEmpty;
    }

    public static DollarPart of(DollarPart first, DollarPart second) throws DollarDeserializationException {
        return ChildDollarOperator.of(first, second, false);
    }

    public static DollarPart of(DollarPart first, DollarPart second, boolean coalesce) throws DollarDeserializationException {
        return new ChildDollarOperator(first, second, coalesce);
    }

    @Override
    public Object apply(Object first, Object second) throws DollarEvaluationException {
        if (first instanceof class_1799) {
            first = NbtUtil.getTagOrEmpty((class_1799)first);
        }
        if (this.propagateEmpty && DollarUtil.isEmpty(first)) {
            return first;
        }
        if (first instanceof class_2487) {
            String key = DollarUtil.asString(second);
            if (((class_2487)first).method_10545(key)) {
                return NbtUtil.toDollarValue(((class_2487)first).method_10580(key));
            }
            return null;
        }
        if (first instanceof List) {
            if (second instanceof Number) {
                int index = ((Number)second).intValue();
                if (index < 0) {
                    index = ((List)first).size() + index;
                }
                if (index < ((List)first).size()) {
                    return DollarUtil.toDollarValue(((List)first).get(index));
                }
                return null;
            }
            if (second instanceof String) {
                ArrayList<Object> results = new ArrayList<Object>(((List)first).size());
                for (Object element : (List)first) {
                    if (element instanceof class_2487) {
                        class_2487 tag = (class_2487)element;
                        if (tag.method_10545((String)second)) {
                            results.add(NbtUtil.toDollarValue(tag.method_10580((String)second)));
                            continue;
                        }
                        throw new DollarEvaluationException("Tag " + tag + " does not contain key " + second);
                    }
                    throw new DollarEvaluationException("Cannot access child of " + first.getClass().getSimpleName() + " with key " + second);
                }
                return results;
            }
        }
        throw new DollarEvaluationException("Cannot access element " + DollarUtil.asString(second) + " on value " + DollarUtil.asString(first));
    }

    @Override
    public void assign(ReferenceResolver referenceResolver, Object value) throws DollarEvaluationException {
        Object parent = this.first.evaluate(referenceResolver);
        if (parent instanceof class_1799) {
            parent = ((class_1799)parent).method_7948();
        }
        if (parent instanceof class_2487) {
            if (this.second == null) {
                throw new DollarEvaluationException("Cannot use anonymous child access on compound tags");
            }
            ((class_2487)parent).method_10566(DollarUtil.asString(this.second.evaluate(referenceResolver)), NbtUtil.asTag(value));
        } else if (parent instanceof List) {
            int index;
            if (this.second == null) {
                index = ((List)parent).size();
            } else {
                Object key = this.second.evaluate(referenceResolver);
                if (key instanceof Number) {
                    index = ((Number)key).intValue();
                } else {
                    throw new DollarEvaluationException("Cannot index list with " + DollarUtil.asString(key));
                }
            }
            if (index < 0) {
                index = ((List)parent).size() + index;
            }
            if (index <= ((List)parent).size()) {
                if (parent instanceof class_2499) {
                    if (index == ((List)parent).size()) {
                        ((class_2499)parent).add((Object)NbtUtil.asTag(value));
                    } else {
                        ((class_2499)parent).method_10606(index, NbtUtil.asTag(value));
                    }
                } else if (index == ((List)parent).size()) {
                    ((List)parent).add(value);
                } else {
                    ((List)parent).set(index, value);
                }
            }
        } else {
            throw new DollarEvaluationException("Cannot access child on value " + DollarUtil.asString(parent));
        }
    }
}

